<?php
header("Content-Type:text/css");
$color = "#f0f"; // Change your Color Here
$secondColor = "#ff8"; // Change your Color Here

function checkhexcolor($color)
{
  return preg_match('/^#[a-f0-9]{6}$/i', $color);
}

if (isset($_GET['color']) and $_GET['color'] != '') {
  $color = "#" . $_GET['color'];
}

if (!$color or !checkhexcolor($color)) {
  $color = "#336699";
}


function checkhexcolor2($secondColor)
{
  return preg_match('/^#[a-f0-9]{6}$/i', $secondColor);
}

if (isset($_GET['secondColor']) and $_GET['secondColor'] != '') {
  $secondColor = "#" . $_GET['secondColor'];
}

if (!$secondColor or !checkhexcolor2($secondColor)) {
  $secondColor = "#336699";
}

function hexToHsl($hex)
{
  $hex   = str_replace('#', '', $hex);
  $red   = hexdec(substr($hex, 0, 2)) / 255;
  $green = hexdec(substr($hex, 2, 2)) / 255;
  $blue  = hexdec(substr($hex, 4, 2)) / 255;
  $cmin  = min($red, $green, $blue);
  $cmax  = max($red, $green, $blue);
  $delta = $cmax - $cmin;
  if ($delta == 0) {
    $hue = 0;
  } elseif ($cmax === $red) {
    $hue = (($green - $blue) / $delta);
  } elseif ($cmax === $green) {
    $hue = ($blue - $red) / $delta + 2;
  } else {
    $hue = ($red - $green) / $delta + 4;
  }
  $hue = round($hue * 60);
  if ($hue < 0) {
    $hue += 360;
  }
  $lightness  = (($cmax + $cmin) / 2);
  $saturation = $delta === 0 ? 0 : ($delta / (1 - abs(2 * $lightness - 1)));
  if ($saturation < 0) {
    $saturation += 1;
  }
  $lightness  = round($lightness * 100);
  $saturation = round($saturation * 100);
  $hsl['h']   = $hue;
  $hsl['s']   = $saturation;
  $hsl['l']   = $lightness;
  return $hsl;
}
?>

.header .main-menu li a:hover, .header .main-menu li a:focus, .header .main-menu li.menu_has_children:hover > a::before, .header .main-menu li .sub-menu li a:hover, .btn-outline--base, .hero-search-form i, a:hover, .footer .footer-menu li a:hover, .page-breadcrumb li a:hover, .page-breadcrumb li:first-child::before, .custom--accordion-two .accordion-button:not(.collapsed), .short-link-list li a:hover, .footer-contact-list li i, .instructor-info-list li i, .contact-card__header .icon i, .contact-card a:hover {
color: <?php echo $color; ?>;
}
.text--base {
color: <?php echo $color; ?> !important;
}
.btn--base, .btn--base:focus, .btn--base:active, .btn-outline--base:hover, .hero-search-form__btn, .testimonial-slider .slick-dots li.slick-active button, .single-review .progress .progress-bar, .contact-area::before, .social-media-list li a:hover, .btn--base:hover,.social-links li a:hover, .scroll-to-top, .cumtom--nav-tabs .nav-item .nav-link.active, .sidebar .widget .widget__title::after, .section-subtitle.border-left::before, .custom--file-upload::before, .icon-btn, .custom--table thead, .preloader .preloader-container .animated-preloader, .preloader .preloader-container .animated-preloader:before, .custom--accordion .accordion-button:not(.collapsed) {
background-color: <?php echo $color; ?>;
}

.tags a:hover{
background-color: <?php echo $color; ?> !important;
border-color : <?php echo $color; ?> !important;
}

.bg--base {
background-color: <?php echo $color; ?> !important;
}
.header.menu-fixed, .footer__bottom, .footer::before {
background-color: <?php echo $secondColor; ?>;
}
.btn-outline--base, .category-card:hover, .mentor-card:hover, .testimonial-card:hover, .blog-card:hover, .social-links li a:hover, .form--control:focus, .custom--accordion .accordion-item {
border-color: <?php echo $color; ?>
}

.navbar-nav li.active a{
color: <?php echo $color; ?>
}

:root{
--base-h: <?php echo hexToHsl($color)['h']; ?>;
--base-s: <?php echo hexToHsl($color)['s']; ?>%;
--base-l: <?php echo hexToHsl($color)['l']; ?>%;
--base-two-h: <?php echo hexToHsl($secondColor)['h']; ?>;
--base-two-s: <?php echo hexToHsl($secondColor)['s']; ?>%;
--base-two-l: <?php echo hexToHsl($secondColor)['l']; ?>%;

--base: var(--base-h) var(--base-s) var(--base-l)

}