<?php

namespace App\Http\Middleware;

use Closure;
use App\Constants\Status;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class Instructor
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (auth()->user()->is_instructor != Status::APPROVED)
        {
            $notify[] = ['error', 'Unauthorized access'];
            return redirect(route('user.home'))->withNotify($notify);
        }

        return $next($request);
    }
}
