<?php

namespace App\Models;

use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Model;

class Comment extends Model
{
    use GlobalStatus;

    protected $with = ['user'];

    public function parent()
    {
        return $this->belongsTo(Comment::class, 'parent_id')->withDefault();
    }

    public function replies()
    {
        return $this->hasMany(Comment::class, 'parent_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id')->withDefault();
    }
}
