<?php

namespace App\Models;

use App\Constants\Status;
use App\Traits\GlobalStatus;
use Illuminate\Support\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;

class Coupon extends Model
{
    use GlobalStatus;

    public function scopeActive()
    {
        return $this->where('status', Status::ENABLE);
    }

    public function statusBadge(): Attribute
    {
        return new Attribute(function () {
            $html = '';

            if (Carbon::parse($this->start_date) <= Carbon::now() && Carbon::parse($this->end_date) >= Carbon::now()) {
                $html = '<span class="text--small badge font-weight-normal badge--success">' . trans('Running') . '</span>';
            } elseif (Carbon::parse($this->start_date) > Carbon::now()) {
                $html = '<span class="text--small badge font-weight-normal badge--primary">' . trans('Upcoming') . '</span>';
            } elseif (Carbon::parse($this->end_date) < Carbon::now()) {
                $html = '<span class="text--small badge font-weight-normal badge--warning">' . trans('Expired') . '</span>';
            }

            return $html;
        });
    }
}
