@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Slug')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($categories as $category)
                                    <tr>
                                        <td>
                                            <div class="user">
                                                <div class="thumb"><img
                                                        src="{{ getImage(getFilePath('category') . '/' . $category->image, getFileSize('category')) }}"
                                                        alt="image"></div>
                                                <span class="name">{{ $category->name }}</span>
                                            </div>
                                        </td>

                                        <td>{{ $category->slug }}</td>
                                        <td>
                                            @php
                                                echo $category->statusBadge;
                                            @endphp
                                        </td>
                                        <td>
                                            <a href="javascript:void(0)" data-category="{{ $category }}"
                                                class="btn btn-sm btn-outline--primary edit">
                                                <i class="las la-pen"></i> @lang('Edit')
                                            </a>

                                            @if ($category->status == Status::DISABLE)
                                                <button class="btn btn-sm btn-outline--success ms-1 confirmationBtn"
                                                    data-question="@lang('Are you sure to enable this category?')"
                                                    data-action="{{ route('admin.categories.main.status', $category->id) }}">
                                                    <i class="la la-eye"></i>@lang('Enable')
                                                </button>
                                            @else
                                                <button class="btn btn-sm btn-outline--danger ms-1 confirmationBtn"
                                                    data-question="@lang('Are you sure to disable this category?')"
                                                    data-action="{{ route('admin.categories.main.status', $category->id) }}">
                                                    <i class="la la-eye-slash"></i>@lang('Disable')
                                                </button>
                                            @endif

                                        </td>

                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($categories->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($categories) }}
                    </div>
                @endif
            </div>
        </div>


    </div>




    <!--Add Modal -->
    <div class="modal fade" id="addModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <form action="{{ route('admin.categories.main.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('Add New Category')</h5>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="las la-times"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label>@lang('Category Name')</label>
                            <input class="form-control" type="text" placeholder="@lang('Category Name')" name="name"
                                required value="{{ old('name') }}">
                        </div>
                        <div class="form-group">
                            <label>@lang('Category Image')</label>
                            <x-image-uploader :imagePath="getImage(null, getFileSize('category'))" :size="false" class="w-100" id="imageCreate"
                                :required="true" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!--Edit Modal -->
    <div class="modal fade" id="editModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <form action="{{ route('admin.categories.main.update') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('Edit Category')</h5>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="las la-times"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="id">
                        <div class="form-group">
                            <label>@lang('Category Name')</label>
                            <input class="form-control" type="text" placeholder="@lang('Category Name')" name="name"
                                required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Category Image')</label>
                            <x-image-uploader :imagePath="getImage(null, getFileSize('category'))" :size="false" class="w-100" id="imageEdit"
                                :required="false" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <x-confirmation-modal />
@endsection



@push('breadcrumb-plugins')
    <button type="button" class="btn btn-sm btn-outline--primary add" data-bs-toggle="modal" data-bs-target="#addModal">
        <i class="las la-plus"></i> @lang('Add New')
    </button>
    <x-search-form placeholder="Name" />
@endpush




@push('script')
    <script>
        'use strict';
        (function($) {
            $('.edit').on('click', function() {
                var category = $(this).data('category')
                $('#editModal').find('input[name=name]').val(category.name)
                $('#editModal').find('input[name=id]').val(category.id)

                var image = category.image;
                var imagePath = '{{ url(getFilePath('category')) }}/' + image;
                $('.image-upload-preview').css('background-image', `url(${imagePath})`);

                $('#editModal').modal('show');
            })

            $('.add').on('click', function() {
                var imagePath = '{{ getImage(null, getFileSize('category')) }}';
                $('.image-upload-preview').css('background-image', `url(${imagePath})`);
            })
        })(jQuery);
    </script>
@endpush
