@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Category')</th>
                                    <th>@lang('Slug')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($subcategories as $subcat)
                                    <tr>
                                        <td>{{ $subcat->name }}</td>
                                        <td>{{ $subcat->category->name }}

                                        </td>
                                        <td>{{ $subcat->slug }}</td>
                                        <td>
                                            @php
                                                echo $subcat->statusBadge;
                                            @endphp
                                        </td>
                                        <td>
                                            <a href="javascript:void(0)" data-subcat="{{ $subcat }}"
                                                data-cat_id="{{ $subcat->category->id }}"
                                                class="btn btn-sm btn-outline--primary edit">
                                                <i class="las la-pen"></i> @lang('Edit')
                                            </a>

                                            @if ($subcat->status == Status::DISABLE)
                                                <button class="btn btn-sm btn-outline--success ms-1 confirmationBtn"
                                                    data-question="@lang('Are you sure to enable this category?')"
                                                    data-action="{{ route('admin.categories.subcategory.status', $subcat->id) }}">
                                                    <i class="la la-eye"></i>@lang('Enable')
                                                </button>
                                            @else
                                                <button class="btn btn-sm btn-outline--danger ms-1 confirmationBtn"
                                                    data-question="@lang('Are you sure to disable this category?')"
                                                    data-action="{{ route('admin.categories.subcategory.status', $subcat->id) }}">
                                                    <i class="la la-eye-slash"></i>@lang('Disable')
                                                </button>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($subcategories->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($subcategories) }}
                    </div>
                @endif
            </div>
        </div>


    </div>


    <!--Add Modal -->
    <div class="modal fade" id="addModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <form action="{{ route('admin.categories.subcategory.store') }}" method="POST">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('Add New Sub Category')</h5>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="las la-times"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label>@lang('Select Category')</label>
                            <select name="category_id" class="form-control select2" data-minimum-results-for-search="-1">
                                <option value="0"> @lang('Select Category')</option>

                                @foreach ($categories as $category)
                                    <option value="{{ $category->id }}">{{ __($category->name) }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label>@lang('Sub Category Name')</label>
                            <input class="form-control" type="text" placeholder="@lang('Sub Category Name')" name="name"
                                required value="{{ old('name') }}">
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Save')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!--Edit Modal -->
    <div class="modal fade" id="editModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <form action="{{ route('admin.categories.subcategory.update') }}" method="POST">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('Edit Sub Category')</h5>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="las la-times"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="id">
                        <div class="form-group">
                            <label>@lang('Select Category')</label>
                            <select name="update_category_id" class="form-control select2"
                                data-minimum-results-for-search="-1">
                                <option value="0"> @lang('Select Category')</option>
                                @foreach ($categories as $category)
                                    <option value="{{ $category->id }}">{{ __($category->name) }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label>@lang('Sub Category Name')</label>
                            <input class="form-control" type="text" placeholder="@lang('Sub Category Name')" name="name"
                                required>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Update')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <x-confirmation-modal />
@endsection



@push('breadcrumb-plugins')
    <button type="button" class="btn btn-outline--primary  btn-sm" data-bs-toggle="modal" data-bs-target="#addModal">
        <i class="las la-plus"></i> @lang('Add New')
    </button>
    <x-search-form placeholder="Name" />
@endpush

@push('style')
    <style>
        .select2-container {
            z-index: 9999
        }
    </style>
@endpush

@push('script')
    <script>
        $(document).ready(function() {
            $('#category_id').select2();
        });
    </script>

    <script>
        'use strict';
        (function($) {
            $('.edit').on('click', function() {
                var subcat = $(this).data('subcat')
                var cat_id = $(this).data('cat_id')
                $('#editModal').find('select[name=update_category_id]').val(cat_id).change()
                $('#editModal').find('input[name=name]').val(subcat.name).change()
                $('#editModal').find('input[name=id]').val(subcat.id)
                $('#editModal').modal('show');
                $('#editModal').find('#update_category_id').select2();

            })
        })(jQuery);
    </script>
@endpush
