@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('Coupon Code')</th>
                                    <th>@lang('Minimum Order')</th>
                                    <th>@lang('Total Limit')</th>
                                    <th>@lang('Per User Limit')</th>
                                    <th>@lang('Start Date')</th>
                                    <th>@lang('End Date')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Expiry')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($coupons as $coupon)
                                    <tr>

                                        <td>{{ $coupon->name }}</td>
                                        <td>
                                            <span
                                                class="text--small badge font-weight-normal badge--success">{{ getAmount($coupon->coupon_amount) }}
                                                {{ $coupon->amount_type == 1 ? '%' : gs()->cur_text }}</span>
                                        </td>
                                        <td class="font-weight-bold">{{ $coupon->coupon_code }}</td>
                                        <td><span class="badge badge-pill bg--primary">{{ gs()->cur_sym }}
                                                {{ getAmount($coupon->min_order_amount) }} </span></td>
                                        <td>{{ $coupon->use_limit }}</td>
                                        <td>{{ $coupon->usage_per_user }}</td>
                                        <td>{{ showDateTime($coupon->start_date, 'Y-m-d') }}</td>
                                        <td>{{ showDateTime($coupon->end_date, 'Y-m-d') }}</td>
                                        <td>
                                            @if ($coupon->status == 1)
                                                <span
                                                    class="text--small badge font-weight-normal badge--success">@lang('Active')</span>
                                            @else
                                                <span
                                                    class="text--small badge font-weight-normal badge--warning">@lang('Inactive')</span>
                                            @endif
                                        </td>
                                        <td>
                                            @php
                                                echo $coupon->statusBadge;
                                            @endphp
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.coupon.edit', $coupon->id) }}"
                                                class="btn btn-sm btn-outline--primary edit">
                                                <i class="las la-pen"></i> @lang('Edit')
                                            </a>

                                            @if ($coupon->status == Status::ENABLE)
                                                <button class="btn btn-sm btn-outline--danger ms-1 confirmationBtn"
                                                    data-question="@lang('Are you sure to disable this coupon?')"
                                                    data-action="{{ route('admin.coupon.status', $coupon->id) }}">
                                                    <i class="la la-eye-slash"></i>@lang('Disable')
                                                </button>
                                            @else
                                                <button class="btn btn-sm btn-outline--success ms-1 confirmationBtn"
                                                    data-question="@lang('Are you sure to enable this coupon?')"
                                                    data-action="{{ route('admin.coupon.status', $coupon->id) }}">
                                                    <i class="la la-eye"></i>@lang('Enable')
                                                </button>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($coupons->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($coupons) }}
                    </div>
                @endif
            </div>
        </div>


    </div>

    <x-confirmation-modal />
@endsection



@push('breadcrumb-plugins')
    <a href="{{ route('admin.coupon.add') }}" class="btn btn-outline--primary btn-sm">
        <i class="las la-plus"></i> @lang('Add New')
    </a>

    <x-search-form placeholder="Coupon code" />
@endpush
