@extends('admin.layouts.app')

@section('panel')
    <section>
        <div class="row gy-4">
            <div class="col-xl-7">
                <div class="video-play-wrapper">
                    <div class="course-details-video">
                        <img class="w-100"
                            src="{{ getImage(getFilePath('course_image') . '/' . @$course->thumbnail, getFileSize('course_image')) }}"
                            alt="image">
                        <a href="{{ $course->preview == Status::YES ? asset(getFilePath('course_video') . '/' . $course->preview_video) : $course->preview_url }}"
                            data-rel="lightcase" class="video-btn"><i class="las la-play"></i></a>
                    </div><!-- course-details-video end -->

                    <iframe class="d-none" src="" frameborder="0"
                        allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen
                        id="video-wrapper"></iframe>

                    <video class="d-none" width="100%" height="500" controls id="video" autoplay>
                        <source src="" type="video/mp4" id="source">
                    </video>
                </div>
            </div>
            <div class="col-xl-5">

                <div class="accordion custom--accordion-two playlist-wrapper" id="courseAccordion">
                    @foreach ($course->chapter as $key => $chapter)
                        @if ($chapter->status == 1 && $chapter->lectures()->count() > 0)
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="heading-{{ $key }}">
                                    <button class="accordion-button {{ $loop->first ? '' : 'collapsed' }}" type="button"
                                        data-bs-toggle="collapse" data-bs-target="#collapse-{{ $key }}"
                                        aria-expanded="{{ $loop->first ? 'true' : 'false' }}"
                                        aria-controls="collapse-{{ $key }}">
                                        {{ $chapter->title }}
                                    </button>
                                </h2>
                                <div id="collapse-{{ $key }}"
                                    class="accordion-collapse collapse {{ $loop->first ? 'show' : '' }}"
                                    aria-labelledby="heading-{{ $key }}" data-bs-parent="#courseAccordion">
                                    <div class="accordion-body">
                                        <ul id="play-list">
                                            @foreach ($chapter->lectures as $lecture)
                                                @if ($lecture->status == 1)
                                                    <li class="">
                                                        <button type="button" class="list-btn"
                                                            data-type="{{ $lecture->type }}"
                                                            data-src="{{ $lecture->type == 2 ? $lecture->url : asset(getFilePath('lecture') . '/' . $lecture->video_file) }}">
                                                            <div class="content pl-0">
                                                                <p><i class="las la-film"></i> {{ $lecture->title }}</p>
                                                            </div>
                                                        </button>
                                                        <div
                                                            class="d-flex flex-wrap align-items-center justify-content-between">
                                                            <span
                                                                class="text-muted fs--14px d-flex align-items-center me-2">
                                                                <i
                                                                    class="las la-play-circle fs--18px"></i>{{ $lecture->duration }}
                                                                @lang('min')
                                                            </span>
                                                            @if ($lecture->file)
                                                                <div class="dropdown ml-3">
                                                                    <button
                                                                        class="btn btn-outline--primary btn-sm dropdown-toggle py-0 px-2 fs--12px"
                                                                        type="button" data-bs-toggle="dropdown"
                                                                        aria-expanded="false">
                                                                        @lang('Resources')
                                                                    </button>
                                                                    <ul class="dropdown-menu p-0">
                                                                        <li class="p-0"><a class="dropdown-item fs--12px"
                                                                                href="{{ route('admin.course.lecture.file.download', $lecture->id) }}">
                                                                                @lang('Download')
                                                                            </a>
                                                                        </li>
                                                                    </ul>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </li>
                                                @endif
                                            @endforeach
                                        </ul><!-- play-list end -->
                                    </div>
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
        </div><!-- row end -->

        <div class="mt-5">
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0">@lang('Course Details')</h5>
                        </div>
                        <div class="card-body">
                            <ul class="caption-list">
                                <li>
                                    <span class="caption">@lang('Total Lectures')</span>
                                    <span class="value">{{ $course->lectures_count }} @lang('lectures')</span>
                                </li>
                                <li>
                                    <span class="caption">@lang('Level')</span>
                                    <span class="value">{{ $course->level->name }}</span>
                                </li>
                                <li>
                                    <span class="caption">@lang('Cerficate')</span>
                                    <span class="value">@lang('Yes')</span>
                                </li>
                            </ul>
                        </div>
                    </div>

                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0">@lang('About this course')</h5>
                        </div>
                        <div class="card-body">
                            <p>
                                @php
                                    echo $course->description;
                                @endphp
                            </p>
                        </div>
                    </div>

                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0">@lang('What will you learn?')</h5>
                        </div>
                        <div class="card-body">
                            <ul class="disc-list">
                                @php
                                    echo $course->will_learn;
                                @endphp
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>


    </section>


    {{-- reject modal --}}
    <div class="modal fade" id="rejectModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Confirmation Alert!')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="" method="POST">
                    @csrf
                    <div class="modal-body ">
                        <p>@lang('Are sure to reject this course ? Please tell some reasons to author.')</p>
                        <textarea name="reasons"placeholder="Write your reasons" required></textarea>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-bs-dismiss="modal">@lang('No')</button>
                        <button type="submit" class="btn btn--primary del">@lang('Yes')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    {{-- approve modal --}}
    <div class="modal fade" id="approveModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Confirmation Alert!')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="" method="POST">
                    @csrf
                    <div class="modal-body ">
                        <p>@lang('Are sure to approve this course ?')</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-bs-dismiss="modal">@lang('No')</button>
                        <button type="submit" class="btn btn--primary del">@lang('Yes')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    @if ($course->status != 2)
        @if ($course->status == 1)
            <a href="javascript:void(0)" data-route="{{ route('admin.course.action', $course->id) }}"
                class="btn btn-outline--primary reject  btn-sm">
                <i class="las la-thumbs-down"></i> @lang('Reject')
            </a>
        @elseif($course->status == 0)
            <a href="javascript:void(0)" data-route="{{ route('admin.course.action', $course->id) }}"
                class="btn btn-outline--primary  approve  btn-sm">
                <i class="las la-check-double"></i> @lang('Approve')
            </a>
        @endif
    @endif
@endpush

@push('style')
    <style>
        .fs--12px {
            font-size: 12px !important;
        }

        .playlist-wrapper {
            max-height: 770px;
            overflow-y: auto;
            scrollbar-width: thin;
            scrollbar-color: darkgrey #e7e7e7;
        }

        @media (max-width: 1399px) {
            .playlist-wrapper {
                max-height: 550px;
            }
        }

        @media (max-width: 767px) {
            .playlist-wrapper {
                max-height: 450px;
            }
        }

        @media (max-width: 575px) {
            .playlist-wrapper {
                max-height: 350px;
            }
        }

        .playlist-wrapper::-webkit-scrollbar {
            width: 7px;
        }

        .playlist-wrapper::-webkit-scrollbar-track {
            box-shadow: inset 0 0 6px rgba(0, 0, 0, 0.3);
        }

        .playlist-wrapper::-webkit-scrollbar-thumb {
            background-color: darkgrey;
            border-radius: 999px;
            -webkit-border-radius: 999px;
            -moz-border-radius: 999px;
            -ms-border-radius: 999px;
            -o-border-radius: 999px;
        }



        .caption-list li .value {
            width: 70%;
            padding-left: .9375rem;
        }

        .caption-list li .caption::after {
            position: absolute;
            content: ':';
            top: 0;
            right: 0;
        }

        .course-details-video {
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.15);
            position: relative;
            overflow: hidden;
        }

        .course-details-video::before {
            position: absolute;
            content: '';
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: #14233c;
            opacity: 0.55;
        }

        .course-details-video .video-btn {
            position: absolute;
            top: 50%;
            left: 50%;
            -webkit-transform: translate(-50%, -50%);
            -ms-transform: translate(-50%, -50%);
            transform: translate(-50%, -50%);
            width: 100px;
            height: 70px;
            background-color: #ea5455;
            color: #fff;
            display: inline-flex;
            justify-content: center;
            align-items: center;
            font-size: 42px;
        }

        .caption-list li .caption {
            width: 30%;
            font-family: "Ubuntu", sans-serif;
            font-weight: 700;
            font-size: .875rem;
            position: relative;
        }

        .caption-list li:first-child {
            padding-top: 0;
        }

        .caption-list li {
            display: flex;
            flex-wrap: wrap;
            padding: .625rem 0;
            font-size: .9375rem;
            border-bottom: 1px dashed #c0cad5;
        }

        .caption-list li:last-child {
            border-bottom: none;
        }

        #video-wrapper,
        video#video {
            width: 100%;
            height: 550px;
        }

        @media (max-width: 767px) {

            #video-wrapper,
            video#video {
                height: 450px;
            }
        }

        @media (max-width: 575px) {

            #video-wrapper,
            video#video {
                height: 350px;
            }
        }

        @media (max-width: 460px) {

            #video-wrapper,
            video#video {
                height: 280px;
            }
        }
    </style>
@endpush

@push('style-lib')
    <link rel="stylesheet" href="{{ asset($activeTemplateTrue . 'css/lightcase.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset($activeTemplateTrue . 'js/lib/lightcase.js') }}"></script>
@endpush

@push('script')
    <script>
        'use strict';
        (function($) {
            $(".list-btn").each(function() {
                $(this).on('click', function() {
                    var dataSrc = $(this).attr("data-src");
                    var preview = $('.course-details-video')
                    if ($(this).data('type') == 2) {
                        $('#video-wrapper').removeClass('d-none')
                        $('#video').addClass('d-none');
                        preview.addClass('d-none')
                        $('#video-wrapper').attr('src', dataSrc);
                    } else {
                        $('#video').removeClass('d-none');
                        $('#video-wrapper').addClass('d-none')
                        preview.addClass('d-none')
                        $('#source').attr('src', dataSrc);
                        document.getElementById('video').load()
                    }

                    // add active class with "list-btn"
                    var element = $(this).parent("li");
                    if (element.hasClass("active")) {
                        element.find("li").removeClass("active");
                    } else {
                        element.addClass("active");
                        element.siblings("li").removeClass("active");
                        element.siblings("li").find("li").removeClass("active");
                    }
                });
            });

            $('.reject').on('click', function() {
                var route = $(this).data('route')
                var modal = $('#rejectModal');
                modal.find('form').attr('action', route)
                modal.modal('show');
            })
            $('.approve').on('click', function() {
                var route = $(this).data('route')
                var modal = $('#approveModal');
                modal.find('form').attr('action', route)
                modal.modal('show');
            })

            $('a[data-rel^=lightcase]').lightcase();

        })(jQuery);
    </script>
@endpush
