@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card  ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Course Title/Author')</th>
                                    <th>@lang('Code')</th>
                                    <th>@lang('Category/Sub Category')</th>
                                    <th>@lang('Price')</th>
                                    <th>@lang('More Info.')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Is Top')</th>
                                    <th>@lang('Action')</th>

                                </tr>
                            </thead>
                            <tbody>
                                @forelse($courses as $k=> $data)
                                    <tr>
                                        <td>{{ $data->title }} <br> <a
                                                href="{{ route('admin.users.detail', $data->author_id) }}">
                                                <span>@</span>{{ @$data->author->username }}</a> </td>

                                        <td>{{ $data->code }}</td>

                                        <td><span class="text--primary">{{ @$data->category->name }}</span> <br>
                                            <span>{{ @$data->subcategory->name }}</span>
                                        </td>

                                        <td>{{ getAmount($data->price) ? gs()->cur_sym : '' }}
                                            {{ getAmount($data->price) ?: 'Free' }}</td>

                                        <td><button class="btn btn-sm btn-outline--primary info"
                                                data-discount="{{ $data->discount ?? 'N/A' }}"
                                                data-level="{{ @$data->level->name }}"
                                                data-chapter="{{ $data->chapter()->count() }}"
                                                data-lec="{{ $data->lectures()->count() }}"> <i class="las la-eye"></i>
                                                @lang(' See')</button></td>

                                        <td>
                                            @if ($data->status == 1)
                                                <span class="badge badge--success">@lang('Active')</span>
                                            @elseif($data->status == 0)
                                                <span class="badge badge--warning">@lang('Inactive')</span>
                                            @elseif($data->status == 2)
                                                <span class="badge badge--danger">@lang('Banned')</span>
                                            @endif
                                        </td>

                                        <td>
                                            @if ($data->is_top == 1 && $data->status != 2)
                                                <span class="badge badge--success">@lang('Yes')</span>
                                            @elseif($data->is_top == 0 && $data->status != 2)
                                                <span class="badge badge--warning">@lang('No')</span>
                                            @else
                                                @lang('N/A')
                                            @endif

                                        </td>

                                        <td>

                                            <div class="dropdown">
                                                <button class="btn btn-sm btn-outline--primary" id="actionButton"
                                                    data-bs-toggle="dropdown">
                                                    <i class="las la-ellipsis-v"></i>@lang('Action')
                                                </button>
                                                <div class="dropdown-menu p-0">

                                                    <a href="{{ route('admin.course.details', $data->id) }}"
                                                        class="dropdown-item">
                                                        <i class="las la-play"></i> @lang('Show Course')
                                                    </a>


                                                    @if ($data->status != 2)
                                                        @if ($data->status == 1)
                                                            <button class="dropdown-item reject"
                                                                data-route="{{ route('admin.course.action', $data->id) }}">
                                                                <i class="las la-thumbs-down"></i> @lang('Reject')
                                                            </button>
                                                        @elseif($data->status == 0)
                                                            <button class="dropdown-item confirmationBtn "
                                                                data-question="@lang('Are you sure to approve this course?')"
                                                                data-action="{{ route('admin.course.action', $data->id) }}">
                                                                <i class="las la-check-double"></i> @lang('Approve')
                                                            </button>
                                                        @endif
                                                    @endif

                                                    @if ($data->status == 2)
                                                        <button class="dropdown-item confirmationBtn"
                                                            data-question="@lang('Are sure to Un-ban this course?')"
                                                            data-action="{{ route('admin.course.ban', $data->id) }}">
                                                            <i class="las la-check-circle"></i> @lang('Un-Ban')
                                                        </button>
                                                    @else
                                                        <button class="dropdown-item ban"
                                                            data-route="{{ route('admin.course.ban', $data->id) }}">
                                                            <i class="las la-ban"></i> @lang('Ban')
                                                        </button>
                                                    @endif

                                                    @if ($data->is_top == 1 && $data->status != 2)
                                                        <button class="dropdown-item confirmationBtn"
                                                            data-question="@lang('Are you sure to Remove this course from top?')"
                                                            data-action="{{ route('admin.course.top', $data->id) }}">
                                                            <i class="las la-reply"></i> @lang('Remove from top')
                                                        </button>
                                                    @elseif($data->is_top == 0 && $data->status != 2)
                                                        <button class="dropdown-item confirmationBtn"
                                                            data-question="@lang('Are you sure to Mark this course as top?')"
                                                            data-action="{{ route('admin.course.top', $data->id) }}">
                                                            <i class="las la-check-square"></i> @lang('Mark as top')
                                                        </button>
                                                    @endif

                                                </div>
                                            </div>

                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-center" colspan="12">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>

                @if ($courses->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($courses) }}
                    </div>
                @endif

            </div><!-- card end -->
        </div>

        @include('admin.courses.action_modals')

        <x-confirmation-modal />

    </div>
@endsection

@push('breadcrumb-plugins')
    <x-search-form placeholder="Course Title / Code" />
@endpush

@push('script')
    <script>
        'use strict';
        (function($) {
            $('.info').on('click', function() {
                var discount = $(this).data('discount')
                var level = $(this).data('level')
                var chapter = $(this).data('chapter')
                var lecture = $(this).data('lec')

                $('#info-modal').find('.level').text(level)
                $('#info-modal').find('.discount').text(discount + '%')
                $('#info-modal').find('.chapter').text(chapter)
                $('#info-modal').find('.lecture').text(lecture)

                $('#info-modal').modal('show')
            })

            $('.ban').on('click', function() {
                var route = $(this).data('route')
                var modal = $('#banModal');
                modal.find('form').attr('action', route)
                modal.modal('show');
            })

            $('.unban').on('click', function() {
                var route = $(this).data('route')
                var modal = $('#unbanModal');
                modal.find('form').attr('action', route)
                modal.modal('show');
            })

            $('.reject').on('click', function() {
                var route = $(this).data('route')
                var modal = $('#rejectModal');
                modal.find('form').attr('action', route)
                modal.modal('show');
            })

        })(jQuery);
    </script>
@endpush
