@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('SL')</th>
                                    <th>@lang('Level Name')</th>
                                    <th>@lang('Total Courses')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($levels as $key => $level)
                                    <tr>

                                        <td>{{ ++$key }}</td>
                                        <td>{{ __($level->name) }}</td>
                                        <td>{{ $level->courses()->count() }}</td>
                                        <td>
                                            <a href="javascript:void(0)" class="btn btn-sm btn-outline--primary edit"
                                                data-level="{{ $level }}"
                                                data-route="{{ route('admin.course.levels.update', $level->id) }}"
                                                data-toggle="tooltip" data-original-title="edit">
                                                <i class="las la-pen "></i> @lang('Edit')
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($levels->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($levels) }}
                    </div>
                @endif
            </div>
        </div>


    </div>




    <div class="modal fade" id="add" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form action="{{ route('admin.course.levels.store') }}" method="POST">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title ">@lang('Add New')</h5>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="las la-times"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label>@lang('Level Name')</label>
                            <input class="form-control" type="text" name="name" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="edit" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form action="" method="POST">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title ">@lang('Update Level')</h5>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="las la-times"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label>@lang('Level Name')</label>
                            <input class="form-control" type="text" name="name" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection



@push('breadcrumb-plugins')
    <button type="button" class="btn btn-outline--primary  btn-sm" data-bs-toggle="modal" data-bs-target="#add">
        <i class="las la-plus"></i> @lang('Add New')
    </button>
    <x-search-form placeholder="Name" />
@endpush

@push('script')
    <script>
        'use strict';
        (function($) {
            $('.edit').on('click', function() {
                var level = $(this).data('level')
                var route = $(this).data('route')

                $('#edit').find('input[name=name]').val(level.name)
                $('#edit').find('form').attr('action', route)
                $('#edit').modal('show')
            })
        })(jQuery);
    </script>
@endpush
