@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('User')</th>
                                    <th>@lang('Email-Mobile')</th>
                                    <th>@lang('Country')</th>
                                    <th>@lang('About Details')</th>
                                    <th>@lang('Resume/CV')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($users as $user)
                                    <tr>
                                        <td>
                                            <span class="fw-bold">{{ $user->fullname }}</span>
                                            <br>
                                            <span class="small">
                                                <a href="{{ route('admin.instructors.detail', $user->id) }}"><span>@</span>{{ $user->username }}</a>
                                            </span>
                                        </td>


                                        <td>
                                            {{ $user->email }}<br>{{ $user->mobileNumber }}
                                        </td>
                                        <td>
                                            <span class="font-weight-bold">{{ $user->country_code }}</span>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-outline--primary detail" data-details="{{ @$user->instructor_info->detail }}"><i class="las la-eye"></i> @lang('see')</button>
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.instructors.download.resume', $user->id) }}" class="btn btn-sm btn-outline--primary"><i class="las la-download"></i> @lang('Download')</a>
                                        </td>

                                        <td>

                                            <button class="btn btn-sm btn-outline--success ms-1 confirmationBtn" data-question="@lang('Are you sure to approve this instructor?')" data-action="{{ route('admin.instructors.approve', $user->id) }}">
                                                <i class="la la-check"></i>@lang('Approve')
                                            </button>
                                            <button class="btn btn-sm btn-outline--danger ms-1 confirmationBtn" data-question="@lang('Are you sure to reject this instructor?')" data-action="{{ route('admin.instructors.reject', $user->id) }}">
                                                <i class="la la-ban"></i>@lang('Reject')
                                            </button>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($users->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($users) }}
                    </div>
                @endif
            </div>
        </div>


        <x-confirmation-modal />


        <!-- Modal -->
        <div class="modal fade" id="details" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title ">@lang('Instructor Details')</h5>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="las la-times"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p class="ins_details"></p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-bs-dismiss="modal">@lang('Close')</button>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection



@push('breadcrumb-plugins')
    <x-search-form placeholder="Username / Email" />
@endpush

@push('script')
    <script>
        'use strict';
        $('.approve').on('click', function() {
            var id = $(this).data('id')
            var modal = $('#approveModal');
            modal.find('input[name=instructor_id]').val(id)
            modal.modal('show');
        })
        $('.reject').on('click', function() {
            var id = $(this).data('id')
            var modal = $('#rejectModal');
            modal.find('input[name=instructor_id]').val(id)
            modal.modal('show');
        })
        $('.detail').on('click', function() {
            var details = $(this).data('details')
            var modal = $('#details');
            modal.find('.ins_details').text(details)
            modal.modal('show');
        })
    </script>
@endpush
