@extends($activeTemplate . 'layouts.frontend')

@php
    $contact = @getContent('contact_us.content', true)->data_values;
    $social = getContent('social_icon.element', false, '', 1);
@endphp

@section('content')
    <section class="pt-100 pb-100 dot--bg">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="section-header">
                        <div class="section-subtitle border-left text--base">{{ __(@$contact->title) }}</div>
                        <h2 class="section-title">{{ __(@$contact->heading) }}</h2>
                    </div>
                </div>
            </div><!-- row end -->
            <div class="contact-area">
                <div class="row gy-5">
                    <div class="col-lg-6">
                        <div class="map-area">
                            <iframe src = "https://maps.google.com/maps?q={{ @$contact->latitude }},{{ @$contact->longitude }}&hl=es;z=14&amp;output=embed"></iframe>
                        </div>
                    </div>
                    <div class="col-lg-6 ps-lg-4">
                        <h3 class="mb-3">@lang('Let\'s talk')</h3>

                        <form method="post" class="verify-gcaptcha">
                            @csrf
                            <div class="row">
                                <div class="form-group col-md-6">
                                    <label class="form-label">@lang('Name')</label>
                                    <input name="name" type="text" class="form-control form--control" value="{{ old('name', @$user->fullname) }}" @if ($user && $user->profile_complete) readonly @endif
                                        placeholder="@lang('Your Name')" required>
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="form-label">@lang('Email')</label>
                                    <input name="email" type="email" class="form-control form--control" value="{{ old('email', @$user->email) }}" @if ($user) readonly @endif
                                        placeholder="@lang('Enter E-Mail Address')" required>
                                </div>
                                <div class="form-group col-lg-12">
                                    <label class="form-label">@lang('Subject')</label>
                                    <input name="subject" type="text" class="form-control form--control" value="{{ old('subject') }}" placeholder="@lang('Write your subject')" required>
                                </div>
                                <div class="form-group col-lg-12">
                                    <label class="form-label">@lang('Message')</label>
                                    <textarea name="message" class="form-control form--control" placeholder="@lang('Write your message')" required>{{ old('message') }}</textarea>
                                </div>
                                <x-captcha />
                                <div class="form-group col-lg-12">
                                    <button type="submit" class="btn btn--base ">@lang('Submit Now')</button>
                                </div>
                            </div>
                        </form>


                    </div>
                </div><!-- row end -->
            </div><!-- contact-area end -->

            <div class="row gy-4 justify-content-center pt-100">
                <div class="col-lg-4 col-md-6">
                    <div class="contact-card">
                        <div class="contact-card__header">
                            <div class="icon">
                                <i class="las la-map-marked-alt"></i>
                            </div>
                            <h3 class="title">@lang('Location')</h3>
                        </div>
                        <p>{{ @$contact->address }}</p>
                    </div><!-- contact-card end -->
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="contact-card">
                        <div class="contact-card__header">
                            <div class="icon">
                                <i class="las la-address-card"></i>
                            </div>
                            <h3 class="title">@lang('Email & Phone')</h3>
                        </div>
                        <p><a href="email:{{ @$contact->email_address }}">{{ @$contact->email_address }}</a></p>
                        <p><a href="tel:{{ @$contact->contact_number }}">{{ @$contact->contact_number }}</a></p>
                    </div><!-- contact-card end -->
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="contact-card">
                        <div class="contact-card__header">
                            <div class="icon">
                                <i class="las la-map-marked-alt"></i>
                            </div>
                            <h3 class="title">@lang('Social Contacts')</h3>
                        </div>
                        <ul class="social-media-list d-flex align-items-center">
                            @foreach ($social as $item)
                                <li><a target="_blank" href="{{ @$item->data_values->url }}" data-toggle="tooltip" title="{{ __($item->data_values->title) }}">
                                        @php
                                            echo @$item->data_values->social_icon;
                                        @endphp
                                    </a></li>
                            @endforeach
                        </ul>
                    </div><!-- contact-card end -->
                </div>
            </div><!-- row end -->
        </div>

        @if (@$sections->secs != null)
            @foreach (json_decode($sections->secs) as $sec)
                @include($activeTemplate . 'sections.' . $sec)
            @endforeach
        @endif
    </section>
@endsection
