@extends($activeTemplate . 'layouts.frontend')
@section('content')

    <section class="pt-100 pb-100 text-break">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="course-details-header mb-5">
                        <h2 class="title">{{ __($course->title) }}</h2>

                        <div class="course-mentor d-flex flex-wrap align-items-center mt-2">
                            <div class="left me-3">
                                <div class="teacher">
                                    <div class="thumb"><img
                                            src="{{ getImage(getFilePath('userProfile') . '/' . $course->author->image, getFileSize('userProfile'), avatar: true) }}"
                                            alt="image"></div>
                                    <p class="name">{{ $course->author->fullname }}</p>
                                </div>
                            </div>
                            <div class="right me-3">
                                <span class="fs--14px">{{ number_format_short($course->courseUsers->count()) }}
                                    @lang('enrolled')</span>
                            </div>
                            <div class="ratings d-flex align-items-center fs--14px mt-1">
                                @php
                                    echo ratings($course->avgRating());
                                @endphp
                                <span class="ms-2">({{ $course->avgRating() }})</span>
                            </div>
                        </div>
                    </div><!-- course-details-header end -->
                    <div class="course-details-video main-course-details-video">
                        <img src="{{ getImage(getFilePath('course_image') . '/' . $course->thumbnail, getFileSize('course_image')) }}"
                            alt="image">
                        <a href="{{ $course->preview == Status::YES ? asset(getFilePath('course_video') . '/' . $course->preview_video) : $course->preview_url }}"
                            data-rel="lightcase" class="video-btn"><i class="las la-play"></i></a>
                    </div><!-- course-details-video end -->
                    <div class="course-details-box mt-5">
                        <h3 class="mb-3">@lang('What Will You Learn?')</h3>
                        @php
                            echo $course->will_learn;
                        @endphp
                    </div><!-- course-details-box end -->



                    <h3 class="mt-5 mb-3">@lang('Course Content')</h3>
                    <div class="accordion custom--accordion-two" id="courseAccordion">
                        @foreach ($course->chapter as $key => $chapter)
                            @if ($chapter->status == Status::ACTIVE && $chapter->lectures()->count() > 0)
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="headingOne">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapse-{{ $key }}" aria-expanded="true"
                                            aria-controls="collapseOne">
                                            {{ $chapter->title }}
                                        </button>
                                    </h2>
                                    <div id="collapse-{{ $key }}"
                                        class="accordion-collapse collapse {{ $loop->first ? 'show' : '' }}"
                                        aria-labelledby="headingOne" data-bs-parent="#courseAccordion">
                                        <div class="accordion-body">
                                            <ul class="course-video-list">
                                                @foreach ($chapter->lectures as $lecture)
                                                    @if ($lecture->status == Status::ACTIVE)
                                                        <li>
                                                            @php
                                                                if ($lecture->visibility == Status::PRIVATE) {
                                                                    $videoSrc = 'javascript:void(0)';
                                                                } else {
                                                                    if ($lecture->type == 1) {
                                                                        $videoSrc = asset(
                                                                            getFilePath('lecture') .
                                                                                '/' .
                                                                                $lecture->video_file,
                                                                        );
                                                                    } else {
                                                                        $videoSrc = $lecture->url;
                                                                    }
                                                                }
                                                            @endphp
                                                            <a href="{{ $videoSrc }}"
                                                                @if ($lecture->visibility == Status::PUBLIC) data-rel="lightcase" @endif>
                                                                <div class="content">
                                                                    <p><span class="me-3"><i
                                                                                class="fas fa-play-circle"></i>
                                                                            {{ $lecture->title }} </span> <span><i
                                                                                class="las la-clock"></i>
                                                                            {{ $lecture->duration }}</span></p>
                                                                </div>

                                                                <div class="video-status fs--18px">
                                                                    @if ($lecture->visibility == 1)
                                                                        <i class="las la-unlock"></i>
                                                                    @else
                                                                        <i class="las la-lock"></i>
                                                                    @endif
                                                                </div>
                                                            </a>
                                                        </li>
                                                    @endif
                                                @endforeach
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>

                    <div class="show-img mt-3 rounded-3 overflow-hidden d-lg-block d-none">
                        @php
                            echo advertisements('728x90');
                        @endphp
                    </div>

                    <div class="course-details-box mt-5">
                        <h3 class="mb-3">@lang('About This Course')</h3>
                        @php
                            echo $course->description;
                        @endphp
                    </div>

                    <h3 class="mt-5 mb-3">@lang('Instructor')</h3>
                    <div class="instructor-card">
                        <div class="thumb">
                            <img src="{{ getImage(getFilePath('userProfile') . '/' . $course->author->image, getFileSize('userProfile'), avatar: true) }}"
                                alt="image">
                        </div>
                        <div class="content">
                            <h4 class="name">{{ $course->author->fullname }}</h4>
                            <span class="mt-1">{{ @$course->author->instructor_info->occupation }}</span>
                            <ul class="instructor-info-list d-flex flex-wrap align-items-center">
                                <li>
                                    <i class="las la-layer-group"></i>
                                    <span>{{ $course->author->courses()->count() }} @lang('Courses')</span>
                                </li>
                                <li>
                                    <i class="las la-user-friends"></i>
                                    <span>{{ $course->author->totalEnrolled()->count() }} @lang('Students')</span>
                                </li>
                                <li>
                                    <i class="las la-star"></i>
                                    <span>{{ $course->author->totalReview()->count() }} @lang('Reviews')</span>
                                </li>
                            </ul>
                        </div>
                        <p class="w-100 mt-2">{{ @$course->author->instructor_info->detail }}</p>
                    </div>

                    <div class="show-img mt-3 rounded-3 overflow-hidden d-lg-block d-none">
                        @php
                            echo advertisements('728x90');
                        @endphp
                    </div>

                    <ul class="nav nav-tabs cumtom--nav-tabs mt-5" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="comment-tab" data-bs-toggle="tab" data-bs-target="#comment"
                                type="button" role="tab" aria-controls="comment"
                                aria-selected="true">@lang('Comments')</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="overview-tab" data-bs-toggle="tab" data-bs-target="#overview"
                                type="button" role="tab" aria-controls="overview"
                                aria-selected="false">@lang('All Reviews')</button>
                        </li>

                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="annoucement-tab" data-bs-toggle="tab" data-bs-target="#annoucement"
                                type="button" role="tab" aria-controls="annoucement"
                                aria-selected="false">@lang('Give Review')</button>
                        </li>
                    </ul>
                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="comment" role="tabpanel"
                            aria-labelledby="comment-tab">
                            <div class="comment-area">
                                <h3 class="block-title">{{ $course->comments_count }} @lang('Comments')</h3>

                                <form action="{{ route('user.post.comment') }}" method="POST">
                                    @csrf
                                    <input type="hidden" name="course_id" value="{{ $course->id }}">
                                    <textarea name="comment" class="form--control" placeholder="@lang('Write your comment')"></textarea>
                                    <div class="mt-2 text-end">
                                        <button type="submit" class="btn btn-md btn--base">@lang('Submit')</button>
                                    </div>
                                </form>

                                <ul class="comment-list mt-3">
                                    @foreach ($course->comments as $k => $comment)
                                        <li>
                                            <div class="single-comment-wrap">
                                                <div class="thumb"> <img
                                                        src="{{ getImage(getFilePath('userProfile') . '/' . $comment->user->image, getFileSize('userProfile'), avatar: true) }}"
                                                        alt="comment-thumb"> </div>
                                                <div class="content">
                                                    <h6 class="name">{{ $comment->user->fullname }}</h6>
                                                    <span
                                                        class="reply-time">{{ diffForHumans($comment->created_at) }}</span>
                                                    <a class="reply" data-bs-toggle="collapse"
                                                        href="#reply-btn-{{ $k }}" role="button"
                                                        aria-expanded="false" aria-controls="collapseExample"><i
                                                            class="fa fa-reply"></i></a>
                                                    <p>{{ __($comment->comment) }}</p>
                                                </div>
                                            </div>

                                            <ul>
                                                @foreach ($comment->replies as $reply)
                                                    <li>
                                                        <div class="single-comment-wrap">
                                                            <div class="thumb"> <img
                                                                    src="{{ getImage(getFilePath('userProfile') . '/' . $reply->user->image, getFileSize('userProfile'), avatar: true) }}"
                                                                    alt="comment-thumb"> </div>
                                                            <div class="content">
                                                                <h6 class="name">{{ $reply->user->fullname }}</h6>
                                                                <span
                                                                    class="reply-time">{{ diffForHumans($comment->created_at) }}</span>
                                                                <p>{{ __($reply->comment) }}</p>
                                                            </div>
                                                        </div>
                                                    </li>
                                                @endforeach
                                                <form class="reply-form collapse" id="reply-btn-{{ $k }}"
                                                    action="{{ route('user.post.comment') }}" method="POST">
                                                    @csrf
                                                    <input type="hidden" name="course_id" value="{{ $course->id }}">
                                                    <input type="hidden" name="parent_id" value="{{ $comment->id }}">
                                                    <textarea name="comment" class="form--control" placeholder="@lang('Write your reply')"></textarea>
                                                    <div class="text-end">
                                                        <button type="submit"
                                                            class="btn btn-sm btn--base">@lang('Submit')</button>
                                                    </div>
                                                </form>
                                            </ul>
                                        </li>
                                    @endforeach

                                </ul>
                            </div>
                        </div>


                        <div class="tab-pane fade" id="overview" role="tabpanel" aria-labelledby="overview-tab">
                            <div class="rating-area mt-5">
                                <div class="single-rating-wrapper">
                                    @forelse ($course->reviews as $review)
                                        <div class="single-rating">
                                            <div class="single-rating__thumb">
                                                <img src="{{ getImage(getFilePath('userProfile') . '/' . $review->user->image, getFileSize('userProfile'), avatar: true) }}"
                                                    alt="image">
                                            </div>
                                            <div class="single-rating__content">
                                                <h5 class="name">{{ $review->user->fullname }}</h5>
                                                <div class="d-flex align-items-center mt-1">
                                                    <div
                                                        class="ratings d-flex align-items-center justify-content-end fs--18px">
                                                        @php
                                                            echo ratings($review->stars);
                                                        @endphp
                                                    </div>
                                                    <span
                                                        class="text-muted ms-2">{{ diffForHumans($review->created_at) }}</span>
                                                </div>
                                                <p class="mt-2">{{ __($review->review) }}</p>
                                            </div>
                                        </div><!-- single-rating end -->
                                    @empty
                                        <div class="single-rating">
                                            <div class="single-rating__content">
                                                <div class="d-flex align-items-center mt-1">
                                                    <h4>@lang('No reviews yet !!')</h4>
                                                </div>
                                            </div>
                                        </div><!-- single-rating end -->
                                    @endforelse

                                </div>
                            </div>
                        </div>

                        <div class="tab-pane fade" id="annoucement" role="tabpanel" aria-labelledby="annoucement-tab">
                            <div class="annoucement-area mt-4">
                                @guest
                                    <h3 class="block-title text--danger text-center">@lang('Please login first')</h3>
                                @endguest
                                @auth
                                    <form class="review-form rating mt-4" method="POST"
                                        action="{{ route('user.review') }}">
                                        @csrf
                                        <input type="hidden" name="course_id" value="{{ $course->id }}">
                                        <input type="hidden" name="author_id" value="{{ $course->author->id }}">
                                        <div class="form-group d-flex flex-wrap">
                                            <label class="review-label text-dark fw-medium mb-0 me-3">@lang('Your Ratings')
                                                :</label>
                                            <div class="rating-form-group">
                                                <label class="star-label">
                                                    <input type="radio" name="rating" value="1" />
                                                    <span class="icon"><i class="las la-star"></i></span>
                                                </label>
                                                <label class="star-label">
                                                    <input type="radio" name="rating" value="2" />
                                                    <span class="icon"><i class="las la-star"></i></span>
                                                    <span class="icon"><i class="las la-star"></i></span>
                                                </label>
                                                <label class="star-label">
                                                    <input type="radio" name="rating" value="3" />
                                                    <span class="icon"><i class="las la-star"></i></span>
                                                    <span class="icon"><i class="las la-star"></i></span>
                                                    <span class="icon"><i class="las la-star"></i></span>
                                                </label>
                                                <label class="star-label">
                                                    <input type="radio" name="rating" value="4" />
                                                    <span class="icon"><i class="las la-star"></i></span>
                                                    <span class="icon"><i class="las la-star"></i></span>
                                                    <span class="icon"><i class="las la-star"></i></span>
                                                    <span class="icon"><i class="las la-star"></i></span>
                                                </label>
                                                <label class="star-label">
                                                    <input type="radio" name="rating" value="5" />
                                                    <span class="icon"><i class="las la-star"></i></span>
                                                    <span class="icon"><i class="las la-star"></i></span>
                                                    <span class="icon"><i class="las la-star"></i></span>
                                                    <span class="icon"><i class="las la-star"></i></span>
                                                    <span class="icon"><i class="las la-star"></i></span>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <textarea name="review" class="form--control" id="review-comments" required placeholder="@lang('Say Something about this course')"></textarea>
                                        </div>
                                        <button type="submit" class="btn btn--base">@lang('Submit Review')</button>
                                    </form>
                                @endauth
                            </div>
                        </div>
                    </div>

                </div>
                <div class="col-lg-4 ps-lg-5 mt-lg-0 mt-5">
                    <div class="course-details-sidebar">
                        <div class="course-details-widget bg--base text-white">
                            <div class="d-flex align-items-center">
                                @if ($course->value == 1 && $course->discount)
                                    <h2 class="course-price me-2 text-white newPrice">
                                        {{ gs()->cur_sym }}{{ getAmount($course->discountPrice()) }}</h2>
                                    <del class="me-2 del">{{ gs()->cur_sym }}{{ getAmount($course->price) }}</del>
                                    <span>{{ $course->discount . '%' }} @lang('off')</span>
                                @else
                                    <h2 class="course-price me-2 text-white newPrice">
                                        @if ($course->value == 1)
                                            {{ gs()->cur_sym }} {{ getAmount($course->price) }}
                                        @else
                                            @lang('Free')
                                        @endif
                                    </h2>
                                @endif
                            </div>
                            <h6 class="mt-4 mb-3 text-white">@lang('This course includes'):</h6>
                            <ul class="course-widget-feature">
                                <li><i class="fas fa-play-circle"></i> {{ $course->totalDuration() }} @lang('hours on-demand video')
                                </li>
                                <li><i class="far fa-file"></i> {{ $course->lectures_count }} @lang('Lectures')</li>
                                <li><i class="fas fa-infinity"></i>@lang('Full lifetime access')</li>

                            </ul>
                            @auth
                                @if (auth()->user()->is_instructor != 1)
                                    @if (\App\Models\UserCourse::where('user_id', auth()->id())->where('course_id', $course->id)->first())
                                        <a href="{{ route('user.course.play', [$course->id, $course->slug]) }}"
                                            class="btn btn--light mt-5 w-100">@lang('Goto Course')</a>
                                    @else
                                        <a href="javascript:void(0)" class="btn btn--light mt-5 w-100 purchase"
                                            data-payment_route="{{ route('user.payment', $course->code) }}">@lang('Purchase')</a>

                                        @if ($course->value != 0)
                                            <a href="javascript:void(0)"
                                                class="coupon-open d-block text-center text-white mt-2">@lang('Apply Coupon Code')</a>
                                            <form class="coupon-form mt-4">
                                                <div class="input-group coupon-div">
                                                    <input type="hidden" name="course_id" value="{{ $course->id }}"
                                                        id="courseid">
                                                    <input type="text" name="coupon" class="form--control"
                                                        autocomplete="off" placeholder="@lang('Coupon code')" id="coupon">
                                                    <button type="button" class="btn btn--secondary"
                                                        id="apply-coupon">@lang('Apply')</button>
                                                </div>
                                            </form>
                                        @endif
                                    @endif
                                @else
                                    @if ($course->author_id != auth()->id())
                                        @if (\App\Models\UserCourse::where('user_id', auth()->id())->where('course_id', $course->id)->first())
                                            <a href="{{ route('user.course.play', [$course->id, $course->slug]) }}"
                                                class="btn btn--light mt-5 w-100 ">@lang('Goto Course')</a>
                                        @else
                                            <a href="javascript:void(0)" class="btn btn--light mt-5 w-100 purchase"
                                                data-payment_route="{{ route('user.payment', $course->code) }}">@lang('Purchase')</a>
                                        @endif
                                    @endif
                                @endif
                            @else
                                <a href="{{ route('user.login') }}" class="btn btn--light mt-5 w-100">@lang('Purchase')</a>
                            @endauth


                        </div><!-- course-details-widget end -->
                        <div class="course-details-review mt-3">
                            <div class="rating-area d-flex flex-wrap align-items-center justify-content-between mb-4">
                                <div class="rating">{{ $course->avgRating() }}</div>
                                <div class="content">
                                    <div class="ratings d-flex align-items-center justify-content-end fs--18px">
                                        @php
                                            echo ratings($course->avgRating());
                                        @endphp
                                    </div>
                                    <span class="mt-1 text-muted fs--14px">@lang('Based on')
                                        {{ $course->reviews->count() }} @lang('ratings')</span>
                                </div>
                            </div>

                            @for ($i = 5; $i > 0; $i--)
                                <div class="single-review">
                                    <p class="star"><i class="las la-star text--base"></i> {{ $i }}</p>
                                    <div class="progress">
                                        <div class="progress-bar" role="progressbar"
                                            style="width: {{ $course->starCount($i) }}%"
                                            aria-valuenow="{{ $course->starCount($i) }}" aria-valuemin="0"
                                            aria-valuemax="100">
                                        </div>
                                    </div>
                                    <span class="percentage">{{ $course->starCount($i) }}%</span>
                                </div><!-- single-review end -->
                            @endfor

                        </div>
                        <div class="course-details-review mt-3">
                            <h5 class="mb-3">@lang('Course Tags')</h5>
                            <div class="tags">
                                @if (!empty($course->tags))
                                    @foreach ($course->tags as $tag)
                                        <a href="{{ route('courses', ['search' => $tag]) }}">{{ __($tag) }}</a>
                                    @endforeach
                                @else
                                    <p>@lang('No tags found')</p>
                                @endif
                            </div>
                        </div>
                    </div><!-- course-details-sidebar end -->
                </div>
            </div>
        </div>
    </section>


    <div class="modal" tabindex="-1" id="purchaseModal">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content p-3">
                <form action="{{ route('user.purchase') }}" method="POST">
                    @csrf
                    <div class="d-flex justify-content-between p-2">
                        <h6>@lang('Choose the option below')</h6>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-bodytext-center">
                        <input type="hidden" name="course_id" value="{{ $course->id }}">
                    </div>
                    <div class="modal-footer border-0 justify-content-center">
                        @if ($course->value == 0)
                            <button type="submit" class="btn btn--dark btn-md w-100 balace">@lang('Enroll')</button>
                        @else
                            <button type="submit" class="btn btn--dark btn-md w-100 balace">{{ gs()->site_name }}
                                @lang('Balance')</button>
                            <a href="" class="btn btn--base btn-md w-100 gateway">@lang('Gateway')</a>
                        @endif

                    </div>
                </form>
            </div>
        </div>
    </div>


@endsection

@push('script')
    <script>
        'use strict';
        (function($) {
            $('.coupon-open').on('click', function() {
                $('.coupon-form').slideToggle();
            });

            $('.purchase').on('click', function() {
                $('#purchaseModal').find('.gateway').attr('href', $(this).data('payment_route'))
                $('#purchaseModal').modal('show')
            });


            $('a[data-rel^=lightcase]').lightcase();


            $('#apply-coupon').on('click', function() {


                var coupon = $(this).parents('.coupon-div').find('#coupon').val();
                var courseid = $(this).parents('.coupon-div').find('#courseid').val();
                var route = "{{ route('user.apply.coupon') }}"
                var data = {
                    coupon: coupon,
                    course_id: courseid,
                    _token: '{{ csrf_token() }}'
                }
                $.post(route, data)
                    .then(function(response) {

                        if (response.coupon) {
                            $.each(response.coupon, function(i, val) {
                                notify('error', val);
                            });

                        } else {
                            notify('success', response.yes);

                            $('.newPrice').text('{{ gs()->cur_sym }}' + ' ' + response.newPrice)
                            $('.del').addClass('d-none');

                            if (response.newPrice <= 0) {
                                btnDisable('.gateway')
                            }
                        }
                    })
            })

            function btnDisable(btn) {
                $(btn).addClass('d-none');
            }

            $('.advert').on('click', function() {
                var ad_id = $(this).data('advertid')
                var data = {
                    ad_id: ad_id,
                    _token: '{{ csrf_token() }}'
                }
                var route = "{{ route('ad.click') }}"
                $.post(route, data).then(function(res) {})
            })

        })(jQuery);
    </script>
@endpush
