@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <section class="pt-100 pb-100">
        <div class="container">
            <div class="row">
                <div class="col-lg-3 pe-4">
                    <button class="action-sidebar-open mb-4"><i class="las la-sliders-h"></i> @lang('Filter')</button>
                    <div class="action-sidebar">
                        <button class="action-sidebar-close"><i class="las la-times"></i></button>
                        <div class="action-widget pt-0">
                            <h4 class="action-widget__title">@lang('Course filter by')</h4>
                            <div class="action-widget__body">
                                <select class="select2" data-minimum-results-for-search="-1"
                                    onChange="window.location.href=this.value">
                                    <option value="{{ queryBuild('type', '') }}"
                                        {{ request('type') == '' ? 'selected' : '' }}>@lang('Select type')</option>
                                    <option value="{{ queryBuild('type', 1) }}"
                                        {{ request('type') == 1 ? 'selected' : '' }}>@lang('Top Courses')</option>
                                    <option value="{{ queryBuild('type', 2) }}"
                                        {{ request('type') == 2 ? 'selected' : '' }}>@lang('Latest Courses')</option>
                                </select>
                            </div>
                        </div><!-- action-widget end -->
                        <div class="action-widget">
                            <h4 class="action-widget__title">@lang('Filter by price')</h4>
                            <div class="action-widget__body">
                                <div class="action-widget__body">
                                    <select class="select2" data-minimum-results-for-search="-1"
                                        onChange="window.location.href=this.value">
                                        <option value="{{ queryBuild('value', '') }}"
                                            {{ request('value') == '' ? 'selected' : '' }}>@lang('All')</option>
                                        <option value="{{ queryBuild('value', 'free') }}"
                                            {{ request('value') == 'free' ? 'selected' : '' }}>@lang('Free')</option>
                                        <option value="{{ queryBuild('value', 'premium') }}"
                                            {{ request('value') == 'premium' ? 'selected' : '' }}>@lang('Premium')
                                        </option>
                                    </select>
                                </div>

                            </div>
                        </div><!-- action-widget end -->
                        <div class="action-widget">
                            <h6 class="action-widget__title">@lang('Category')</h6>
                            <div class="action-widget__body">
                                <div class="action-widget__body">
                                    <select class="select2 cat" onChange="window.location.href=this.value">
                                        <option value="{{ queryBuild('category', '') }}"
                                            {{ request('category') == '' ? 'selected' : '' }}>@lang('All')</option>
                                        @foreach ($categories as $category)
                                            <option value="{{ queryBuild('category', $category->slug) }}"
                                                {{ request('category') == $category->slug ? 'selected' : '' }}>
                                                {{ $category->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                            </div>
                        </div><!-- action-widget css end -->

                        <div class="action-widget">
                            <h6 class="action-widget__title">@lang('Level')</h6>
                            <div class="action-widget__body">
                                <div class="action-widget__body">
                                    <select class="select2" onChange="window.location.href=this.value">
                                        <option value="{{ queryBuild('level', '') }}"
                                            {{ request('level') == '' ? 'selected' : '' }}>@lang('All')</option>
                                        @foreach ($levels as $level)
                                            <option value="{{ queryBuild('level', $level->slug) }}"
                                                {{ request('level') == $level->slug ? 'selected' : '' }}>
                                                {{ $level->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                            </div>
                        </div><!-- action-widget css end -->
                    </div><!-- action-sidebar end -->
                    <div class="show-img mt-3 rounded-3 overflow-hidden d-lg-block d-none">
                        @php
                            echo advertisements('300x250');
                        @endphp
                    </div>
                    <div class="show-img mt-3 rounded-3 overflow-hidden d-lg-block d-none">
                        @php
                            echo advertisements('300x250');
                        @endphp
                    </div>
                    <div class="show-img mt-3 rounded-3 overflow-hidden d-lg-block d-none">
                        @php
                            echo advertisements('300x600');
                        @endphp
                    </div>
                </div>
                <div class="col-lg-9">
                    <form class="hero-search-form category-search-form mb-3" action="" method="GET">
                        <i class="las la-search"></i>
                        <input type="text" name="search" autocomplete="on" class="form--control"
                            placeholder="@lang('title, tags eg. web design, art, skill development')...">
                        <button type="submit" class="hero-search-form__btn">@lang('Search')</button>
                    </form>
                    @forelse ($courses as $course)
                        <div class="course-card list-view">
                            <div class="course-card__thumb">
                                <img src="{{ getImage(getFilePath('course_image') . '/thumb_' . $course->thumbnail, getFileThumbSize('course_image')) }}"
                                    alt="image">
                                <div class="course-type"><i class="las la-file-video"></i></div>
                            </div>
                            <div class="course-card__content">
                                <span class="course-tag fs--12px">{{ @$course->subcategory->name }}</span>
                                <h6 class="course-title mt-2"><a
                                        href="{{ route('course.details', [$course->id, $course->slug]) }}">{{ $course->title }}</a>
                                </h6>
                                <span class="badge bg--primary font-weight-normal mt-2">{{ $course->level->name }}</span>
                                <div class="ratings d-flex align-items-center fs--14px mt-1">
                                    @php
                                        echo ratings($course->avgRating());
                                    @endphp
                                    <span class="ms-2">({{ $course->avgRating() }})</span>
                                </div>
                                <div class="course-mentor mt-2">
                                    <div class="left">
                                        <div class="teacher">
                                            <div class="thumb"><img
                                                    src="{{ getImage(getFilePath('userProfile') . '/' . $course->author->image, getFileSize('userProfile'), avatar: true) }}"
                                                    alt="image"></div>
                                            <p class="name">{{ $course->author->fullname }}</p>
                                        </div>
                                    </div>
                                    <div class="right">
                                        <span class="fs--14px">{{ number_format_short($course->courseUsers->count()) }}
                                            @lang('enrolled')</span>
                                    </div>
                                </div>
                            </div>
                            <div class="course-footer">
                                <div class="w-100 text-center">
                                    @if ($course->discount)
                                        <del
                                            class="text-muted fs--14px">{{ gs()->cur_sym }}{{ getAmount($course->price) }}</del>
                                        <div class="course-price">
                                            {{ gs()->cur_sym }}{{ getAmount($course->discountPrice()) }}</div>
                                    @else
                                        <div class="course-price">
                                            @if (getAmount($course->price))
                                                {{ gs()->cur_sym }}{{ getAmount($course->price) }}
                                            @else
                                                @lang('Free')
                                            @endif
                                        </div>
                                    @endif
                                    <a href="{{ route('course.details', [$course->id, $course->slug]) }}"
                                        class="btn btn-sm btn--base w-100 mt-4">@lang('View Details')</a>
                                </div>
                            </div>
                        </div><!-- course-card end -->
                    @empty
                        <div class="course-card list-view">
                            <div class="course-card__thumb text-md-start text-center not__found">
                                <img src="{{ getImage('assets/images/not_found.jpg') }}" width="60%" alt="image">
                            </div>
                            <div class="course-card__content d-flex align-items-center justify-content-center">
                                <h5>@lang('No courses found !')</h5>
                            </div>
                        </div>
                    @endforelse
                    <div class="text-end mt-4 pagination-md">
                        <ul class="pagination d-inline-flex">
                            {{ paginateLinks($courses, '') }}
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('style')
    <style>
        .select2 .dropdown-wrapper {
            display: none;
        }

        .select2-container:has(.select2-selection--single) {
            width: 100% !important;
        }

        .select2-dropdown {
            border: 0 !important;
            margin-top: 8px !important;
            border-radius: 5px !important;
            box-shadow: 0 3px 9px rgba(50, 50, 9, 0.05), 6px 4px 19px rgb(115 103 240 / 20%)
        }

        .select2-search--dropdown {
            padding: 10px 10px !important;
            border-color: #ced4da !important;
        }

        .select2-container--default .select2-search--dropdown .select2-search__field {
            border-color: hsl(var(--base)) !important;
            padding: 10px 20px;
            background: transparent !important;
            color: hsl(var(--white)) !important;
            border-radius: 4px;
        }

        .select2-results__option.select2-results__option--selected,
        .select2-results__option--selectable,
        .select2-container--default .select2-results__option--disabled {
            padding: 12px 14px !important;
            border-bottom: 1px solid #eee;
        }

        .select2-results__option.select2-results__message {
            text-align: center !important;
            padding: 12px 14px !important;
        }

        .select2-container--default .select2-results>.select2-results__options::-webkit-scrollbar {
            width: 8px;
            border-radius: 5px;
        }

        .select2-container--default .select2-results>.select2-results__options::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 5px;
        }

        .select2-container--default .select2-results>.select2-results__options::-webkit-scrollbar-thumb {
            background: #ddd;
        }

        .select2-container--default .select2-results>.select2-results__options::-webkit-scrollbar-thumb:hover {
            background: #ddd;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow b {
            display: none;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow:after {
            position: absolute;
            right: 10px;
            top: 30%;
            content: "\f107";
            font-family: "Line Awesome Free";
            font-weight: 900;
            transition: .3s;
            transform: translateY(-50%);
        }

        .selection {
            width: 100%;
        }

        .select2-selection.select2-selection--single {
            background: hsl(var(--base-two));
            border-color: hsl(0deg 0% 83.61%) !important;
            color: hsl(var(--white));
            padding: 10px 24px !important;
            line-height: 1.2;
            height: 53px !important;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 53px !important;
        }

        .select2-container--default.select2-container--open .select2-selection--single .select2-selection__arrow:after {
            content: "\f106";
            top: 5px;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            color: hsl(var(--white)/.7);
            line-height: 32px !important;
        }

        .select2-results__option:last-child {
            border-bottom-left-radius: 5px;
            border-bottom-right-radius: 5px;
        }

        .select2-results__option:first-child {
            border-top-left-radius: 5px;
            border-top-right-radius: 5px;
        }

        .select2-results__option.select2-results__option--selected,
        .select2-container--default .select2-results__option--highlighted.select2-results__option--selectable {
            background-color: #f1f1f1 !important;
            color: #000 !important;
        }

        .select2-container--default .select2-search--dropdown .select2-search__field:focus {
            box-shadow: 0 0 25px rgba(115, 103, 240 0.071) !important;
            outline: 0 !important;
        }

        .select2-dropdown .country-flag {
            width: 25px;
            height: 25px;
            border-radius: 8px;
        }

        .select2-dropdown {
            background-color: #fff !important;
        }

        .select2-dropdown .gateway-title {
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 0px !important;
        }

        .select2-dropdown .gateway-subtitle {
            font-size: 12px;
            margin-bottom: 0px !important;
        }

        .select2-container--open .select2-selection.select2-selection--single,
        .select2-container--open .select2-selection.select2-selection--multiple {
            border-color: hsl(var(--base)) !important;
            border-radius: .375rem !important;
        }

        .select2-results__option.select2-results__option--selected,
        .select2-container--default .select2-results__option--highlighted.select2-results__option--selectable {
            background-color: hsl(var(--white)/.3) !important;
            color: hsl(var(--white)) !important;
        }

        .select2-results__option.select2-results__option--selected,
        .select2-results__option--selectable,
        .select2-container--default .select2-results__option--disabled {
            border: 1px solid hsl(var(--white)/.1) !important;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            color: hsl(var(--white) / .7);
            line-height: 32px !important;
            padding-left: 0px;
        }
    </style>
@endpush

@push('script')
    <script>
        'use strict';
        (function($) {
            $('.advert').on('click', function() {
                var ad_id = $(this).data('advertid')
                var data = {
                    ad_id: ad_id,
                    _token: '{{ csrf_token() }}'
                }
                var route = "{{ route('ad.click') }}"
                $.post(route, data).then(function(res) {})
            })
        })(jQuery);
    </script>
@endpush
