@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @php
        $banner = getContent('banner.content', true)->data_values;
    @endphp
    <section class="hero bg_img" style="background-image: url('{{ frontendImage('banner', $banner->background_image, '1920x640') }}');">
        <div class="container">
            <div class="row align-items-center justify-content-xl-start justify-content-center">
                <div class="col-xl-6 col-lg-9 text-xl-start text-center">
                    <h2 class="hero__title text-white">{{ __(@$banner->heading) }}</h2>
                    <p class="hero__description text-white mt-3">{{ __(@$banner->sub_heading) }}</p>
                    <form class="hero-search-form mt-xl-5 mt-4" action="{{ route('courses') }}" method="GET">
                        <i class="las la-search"></i>
                        <input type="text" name="search" autocomplete="on" class="form--control" placeholder="@lang('title, tags eg. web design, art, skill development')...">
                        <button type="submit" class="hero-search-form__btn">@lang('Search')</button>
                    </form>
                </div>
            </div><!-- row end -->
        </div>
    </section>

    @if ($sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include($activeTemplate . 'sections.' . $sec)
        @endforeach
    @endif
@endsection
