@php
    $footer = getContent('footer.content', true)->data_values;
    $social = getContent('social_icon.element', false, '', 1);
    $policies = getContent('policies.element', false, '', 1);
@endphp
<footer class="footer bg_img"
    style="background-image: url('{{ frontendImage('footer', @$footer->background_image, '1920x1280') }}');">
    <div class="footer__top">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 text-center">
                    <a class="footer-logo" href="{{ route('home') }}"><img src="{{ siteLogo() }}" alt="Logo"></a>
                    <ul class="footer-menu d-flex flex-wrap justify-content-center mt-4">
                        @foreach ($pages as $k => $data)
                            <li><a href="{{ route('pages', [$data->slug]) }}">{{ __($data->name) }}</a></li>
                        @endforeach
                        <li><a href="{{ route('courses') }}">@lang('Courses')</a></li>
                        <li><a href="{{ route('blog') }}">@lang('Blog')</a></li>
                        <li><a href="{{ route('faq') }}">@lang('Faq')</a></li>
                        @auth
                            <li><a href="{{ route('ticket.index') }}">@lang('Support')</a></li>
                        @endauth
                        @guest
                            <li><a href="{{ route('contact') }}">@lang('Contact')</a></li>
                        @endguest
                    </ul>
                    <ul class="social-links d-flex flex-wrap align-items-center mt-4 justify-content-center">
                        @foreach ($social as $item)
                            <li><a target="_blank" href="{{ @$item->data_values->url }}" data-toggle="tooltip"
                                    title="{{ __($item->data_values->title) }}">
                                    @php
                                        echo @$item->data_values->social_icon;
                                    @endphp
                                </a></li>
                        @endforeach

                    </ul>
                    <div class="col-lg-6 mx-auto mt-3">
                        <p class="text-white">{{ __(@$footer->short_details) }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="footer__bottom">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-6 text-md-start text-center">
                    <p class="text-white">{{ date('Y') }} © <a href="{{ route('home') }}"
                            class="text--base">{{ gs()->site_name }}</a> . @lang('All Right Reserved')</p>
                </div>
                <div class="col-md-6">
                    <ul class="footer-menu d-flex flex-wrap justify-content-end">
                        @foreach ($policies as $links)
                            <li><a
                                    href="{{ route('links', [slug(@$links->data_values->title), $links->id]) }}">{{ __(@$links->data_values->title) }}</a>
                            </li>
                        @endforeach

                    </ul>
                </div>
            </div>
        </div>
    </div>
</footer>
