<header class="header">
    <div class="header__bottom">
        <div class="container">
            <nav class="navbar navbar-expand-xl p-0 align-items-center">
                <a class="site-logo site-title" href="{{ route('home') }}"><img src="{{ siteLogo() }}"
                        alt="Logo"></a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                    aria-expanded="false" aria-label="Toggle navigation">
                    <span class="menu-toggle"></span>
                </button>
                <div class="collapse navbar-collapse mt-lg-0 mt-3" id="navbarSupportedContent">
                    <ul class="navbar-nav main-menu m-auto">
                        <li class="{{ menuActive('home') }}"><a href="{{ url('/') }}">@lang('Home')</a></li>
                        @foreach ($pages as $k => $data)
                            @php $isActive = route('pages', [$data->slug]) == request()->url(); @endphp
                            <li class="@if ($isActive) active @endif"><a
                                    href="{{ route('pages', [$data->slug]) }}">{{ __($data->name) }}</a></li>
                        @endforeach


                        <li class="menu_has_children "><a href="javascript:void(0)">@lang('Category')</a>
                            <ul class="sub-menu">
                                @foreach ($categories as $category)
                                    @if ($category->subcategories->count() > 0)
                                        <li class="menu_has_children"><a
                                                href="javascript:void(0)">{{ __($category->name) }}</a>
                                            <ul class="sub-menu">
                                                @foreach ($category->subcategories as $subcat)
                                                    @php $isCategoryActive = route('courses.category', $subcat->slug) == request()->url(); @endphp
                                                    <li class="@if ($isCategoryActive) active @endif"><a
                                                            href="{{ route('courses.category', $subcat->slug) }}">{{ __($subcat->name) }}</a>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </li>
                                    @endif
                                @endforeach
                            </ul>
                        </li>

                        @auth
                            <li
                                class="menu_has_children {{ menuActive(['user.course.purchased', 'courses', 'course.details']) }}">
                                <a href="javascript:void(0)">@lang('Courses')</a>
                                <ul class="sub-menu">
                                    <li>
                                        <a href="{{ route('user.course.purchased') }}">
                                            @if (auth()->user()->is_instructor == Status::YES)
                                                @lang('Purchased Courses')
                                            @else
                                                @lang('My Courses')
                                            @endif
                                        </a>
                                    </li>
                                    <li><a href="{{ route('courses') }}">@lang('All Courses')</a></li>
                                </ul>
                            </li>
                        @else
                            <li class="{{ menuActive(['courses', 'course.details']) }}"><a
                                    href="{{ route('courses') }}">@lang('Courses')</a>
                            </li>
                        @endauth

                        <li class="{{ menuActive(['blog', 'blog.details']) }}"><a
                                href="{{ route('blog') }}">@lang('Blog')</a></li>
                        @auth
                            <li class="{{ menuActive('ticket.index') }}"><a
                                    href="{{ route('ticket.index') }}">@lang('Support')</a></li>
                        @else
                            <li class="{{ menuActive('contact') }}"><a href="{{ route('contact') }}">@lang('Contact')</a>
                            </li>
                        @endauth
                    </ul>
                    <div class="nav-right align-items-center">
                        @include($activeTemplate . 'partials.language')

                        @guest
                            <a href="{{ route('user.login') }}"
                                class="btn btn-sm btn--base d-flex align-items-center me-2 mt-sm-0 mt-2"><i
                                    class="las la-user fs--18px me-2"></i>@lang('Login')</a>

                            <a href="{{ route('user.register') }}"
                                class="btn btn-sm btn-outline--base d-flex align-items-center mt-sm-0 mt-2"><i
                                    class="las la-user fs--18px me-2"></i>@lang('Sign Up')</a>
                        @endguest

                        @auth
                            <a href="{{ route('user.home') }}"
                                class="btn btn-sm btn-outline--base d-flex align-items-center me-2 mt-sm-0 mt-2"><i
                                    class="las la-home fs--18px me-2"></i>@lang('Dashboard')</a>

                            <a href="{{ route('user.logout') }}"
                                class="btn btn-sm btn--base d-flex align-items-center mt-sm-0 mt-2"><i
                                    class="las la-sign-out-alt fs--18px me-2"></i>@lang('Logout')</a>
                        @endauth
                    </div>
                </div>
            </nav>
        </div>
    </div><!-- header__bottom end -->
</header>

@push('script')
    <script>
        (function($) {
            "use strict";

            $('.menu_has_children').each(function() {
                // Check if any descendant 'li' has the class 'active'
                if ($(this).find('.active').length > 0) {
                    // Change the color of the menu item
                    $(this).addClass('active');
                }
            });

        })(jQuery);
    </script>
@endpush
