<header class="header">
    <div class="header__bottom">
        <div class="container">
            <nav class="navbar navbar-expand-xl p-0 align-items-center">

                <a class="site-logo site-title" href="{{ route('home') }}"><img src="{{ siteLogo() }}"
                        alt="Logo"></a>

                <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                    aria-expanded="false" aria-label="Toggle navigation">
                    <span class="menu-toggle"></span>
                </button>
                <div class="collapse navbar-collapse mt-lg-0 mt-3" id="navbarSupportedContent">

                    <ul class="navbar-nav main-menu m-auto">
                        <li class="{{ menuActive('home') }}"><a href="{{ url('/') }}">@lang('Home')</a></li>
                        @if (auth()->user()->is_instructor == Status::YES)
                            <li class="menu_has_children {{ menuActive(['user.create.course', 'user.courses']) }}"><a
                                    href="javascript:void(0)">@lang('Instructor')</a>
                                <ul class="sub-menu">
                                    <li><a href="{{ route('user.create.course') }}">
                                            @lang('Create Course')</a></li>
                                    <li><a href="{{ route('user.courses') }}">
                                            @lang('My Courses')</a></li>

                                </ul>
                            </li>
                        @endif
                        <li class="menu_has_children {{ menuActive(['user.course.purchased', 'courses']) }}">
                            <a href="javascript:void(0)">@lang('Courses')</a>
                            <ul class="sub-menu">
                                <li>
                                    <a href="{{ route('user.course.purchased') }}">
                                        @if (auth()->user()->is_instructor == Status::YES)
                                            @lang('Purchased Courses')
                                        @else
                                            @lang('My Courses')
                                        @endif
                                    </a>
                                </li>
                                <li><a href="{{ route('courses') }}">@lang('All Courses')</a></li>
                            </ul>
                        </li>


                        <li class="{{ menuActive('user.transactions') }}"><a href="{{ route('user.transactions') }}">
                                @lang('Transactions')</a></li>

                        <li class="menu_has_children {{ menuActive(['user.deposit*']) }}">
                            <a href="javascript:void(0)">@lang('Deposits')</a>
                            <ul class="sub-menu">
                                <li>
                                    <a href="{{ route('user.deposit.history') }}">
                                        @lang('Deposit History')
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ route('user.deposit.index') }}">
                                        @lang('Deposit Now')
                                    </a>
                                </li>
                            </ul>
                        </li>

                        @if (auth()->user()->is_instructor == Status::YES)
                            <li class="menu_has_children {{ menuActive(['user.withdraw*']) }}">
                                <a href="javascript:void(0)">@lang('Withdraws')</a>
                                <ul class="sub-menu">
                                    <li>
                                        <a href="{{ route('user.withdraw.history') }}">
                                            @lang('Withdraw History')
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{ route('user.withdraw') }}">
                                            @lang('Withdraw Now')
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        @endif

                        <li class="menu_has_children"><a href="javascript:void(0)">@lang('More')</a>
                            <ul class="sub-menu">
                                @if (auth()->user()->is_instructor == Status::NO)
                                    <li><a href="{{ route('user.become.instructor') }}">@lang('Become an Instructor')</a></li>
                                @endif
                                <li><a href="{{ route('user.profile.setting') }}">@lang('Profile Setting')</a></li>
                                <li><a href="{{ route('user.change.password') }}">@lang('Change Password')</a></li>
                                <li><a href="{{ route('user.twofactor') }}">@lang('2FA Security')</a></li>
                                <li><a href="{{ route('ticket.index') }}">@lang('Support')</a></li>
                            </ul>
                        </li>


                    </ul>

                    <div class="nav-right align-items-center">

                        @include($activeTemplate . 'partials.language')

                        <a href="{{ route('user.home') }}"
                            class="btn btn-sm btn-outline--base d-flex align-items-center me-2 mt-sm-0 mt-2"><i
                                class="las la-home fs--18px me-2"></i>@lang('Dashboard')</a>

                        <a href="{{ route('user.logout') }}"
                            class="btn btn-sm btn--base d-flex align-items-center mt-sm-0 mt-2"><i
                                class="las la-sign-out-alt fs--18px me-2"></i>@lang('Logout')</a>

                    </div>

                </div>
            </nav>
        </div>
    </div><!-- header__bottom end -->
</header>
