@php
    $content = getContent('testimonial.content', true)->data_values;
    $elements = getContent('testimonial.element', false, '', 1);
@endphp

<section class="pt-100 pb-100 bg_img dark--overlay-two" style="background-image: url('{{ frontendImage('testimonial', @$content->background_image) }}');">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6 text-center">
                <div class="section-header">
                    <h2 class="section-title text-white">{{ __(@$content->heading) }}</h2>
                    <p class="mt-3 text-white">{{ __(@$content->sub_heading) }}</p>
                </div>
            </div>
        </div>
        <div class="testimonial-slider">
            @foreach ($elements as $el)
                <div class="single-slide">
                    <div class="testimonial-card">
                        <div class="thumb">
                            <img src="{{ frontendImage('testimonial', @$el->data_values->author_image) }}" alt="image">
                        </div>
                        <p class="details text-white mt-3">{{ __(@$el->data_values->quote) }}</p>
                        <h6 class="name text--base mt-3">{{ @$el->data_values->author_name }}</h6>
                        <span class="text-white fs--14px">{{ @$el->data_values->designation }}</span>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
