@extends($activeTemplate . 'layouts.auth')

@php
    $content = getContent('login.content', true)->data_values;
@endphp

@section('content')
    <section class="account-section">
        <div class="left">
            <div class="top-el">
                <img src="{{ frontendImage('login', @$content->texture_image_up, '1595x645') }}" alt="image">
            </div>
            <div class="bottom-el">
                <img src="{{ frontendImage('login', @$content->texture_image_down, '1595x645') }}" alt="image">
            </div>
            <div class="account-form-area">
                <div class="text-center mb-4">

                    <a class="site-logo site-title" href="{{ route('home') }}"><img src="{{ siteLogo() }}" alt="Logo"></a>

                </div>

                <div class="d-flex justify-content-center">
                    <div class="verification-code-wrapper">
                        <div class="verification-area">
                            <h5 class="pb-3 text-center border-bottom">@lang('2FA Verification')</h5>
                            <form action="{{ route('user.2fa.verify') }}" method="POST" class="ccount-form mt-5 submit-form">
                                @csrf

                                @include($activeTemplate . 'partials.verification_code')

                                <div class="form--group">
                                    <button type="submit" class="btn btn--base w-100">@lang('Submit')</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>


            </div>
        </div>
        <div class="right bg_img" style="background-image: url('{{ frontendImage('login', @$content->background_image, '1920x1280') }}');">
            <div class="content text-center">
                <h2 class="title text-white">@lang('2FA Verification')</h2>

            </div>
        </div>
    </section>
@endsection

@push('style')
    <style>
        .verification-code input {
            letter-spacing: 39px;
        }
    </style>
@endpush
