@extends($activeTemplate . 'layouts.auth')

@php
    $content = getContent('login.content', true)->data_values;
@endphp

@section('content')
    <section class="account-section">
        <div class="left">
            <div class="top-el">
                <img src="{{ frontendImage('login', @$content->texture_image_up, '1595x645') }}" alt="image">
            </div>
            <div class="bottom-el">
                <img src="{{ frontendImage('login', @$content->texture_image_down, '1595x645') }}" alt="image">
            </div>
            <div class="account-form-area">
                <div class="text-center">

                    <a class="site-logo site-title" href="{{ route('home') }}"><img src="{{ siteLogo() }}"
                            alt="Logo"></a>

                </div>

                <div class="d-flex justify-content-center">
                    <div class="verification-code-wrapper">
                        <div class="verification-area">
                            <form action="{{ route('user.verify.mobile') }}" method="POST"
                                class="account-form submit-form">
                                @csrf
                                <p class="verification-text">@lang('A 6 digit verification code sent to your mobile number') :
                                    +{{ showMobileNumber(auth()->user()->mobileNumber) }}</p>
                                @include($activeTemplate . 'partials.verification_code')
                                <div class="mb-3">
                                    <button type="submit" class="btn btn--base w-100">@lang('Submit')</button>
                                </div>
                                <div class="form-group">
                                    <p class="verification-text">
                                        @lang('If you don\'t get any code'), <span class="countdown-wrapper">@lang('try again after') <span
                                                id="countdown" class="fw-bold">--</span> @lang('seconds')</span> <a
                                            href="{{ route('user.send.verify.code', 'sms') }}"
                                            class="try-again-link d-none"> @lang('Try again')</a>
                                    </p>
                                    <a class="verification-text  text--base"
                                        href="{{ route('user.logout') }}">@lang('Logout')</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="right bg_img"
            style="background-image: url('{{ frontendImage('login', @$content->background_image, '1920x1280') }}');">
            <div class="content text-center">
                <h2 class="title text-white">@lang('Very Your Mobile No. To Get Access')</h2>
            </div>
        </div>
    </section>
@endsection

@push('style')
    <style>
        .verification-code input {
            letter-spacing: 39px;
        }
    </style>
@endpush

@push('script')
    <script>
        var distance = Number("{{ @$user->ver_code_send_at->addMinutes(2)->timestamp - time() }}");
        var x = setInterval(function() {
            distance--;
            document.getElementById("countdown").innerHTML = distance;
            if (distance <= 0) {
                clearInterval(x);
                document.querySelector('.countdown-wrapper').classList.add('d-none');
                document.querySelector('.try-again-link').classList.remove('d-none');
            }
        }, 1000);
    </script>
@endpush
