@extends($activeTemplate . 'layouts.auth')

@php
    $content = getContent('login.content', true)->data_values;
@endphp

@section('content')
    <section class="account-section">
        <div class="left">
            <div class="top-el">
                <img src="{{ frontendImage('login', @$content->texture_image_up, '1595x645') }}" alt="image">
            </div>
            <div class="bottom-el">
                <img src="{{ frontendImage('login', @$content->texture_image_down, '1595x645') }}" alt="image">
            </div>
            <div class="account-form-area">
                <div class="text-center mb-4">
                    <a class="site-logo site-title" href="{{ route('home') }}"><img src="{{ siteLogo() }}"
                            alt="Logo"></a>
                </div>

                @include($activeTemplate . 'partials.social_login')

                <form method="POST" action="{{ route('user.login') }}" class="account-form mt-3 verify-gcaptcha">
                    @csrf

                    <div class="form-group">
                        <label for="email" class="form-label">@lang('Username or Email')</label>
                        <input type="text" name="username" value="{{ old('username') }}"
                            class="form-control form--control" required>
                    </div>

                    <div class="form-group">
                        <div class="d-flex flex-wrap justify-content-between mb-2">
                            <label for="password" class="form-label mb-0">@lang('Password')</label>
                            <a class="text--base forgot-pass" href="{{ route('user.password.request') }}">
                                @lang('Forgot your password?')
                            </a>
                        </div>
                        <input id="password" type="password" class="form-control form--control" name="password" required>
                    </div>

                    <x-captcha />

                    <div class="form-group form-check">
                        <input class="form-check-input" type="checkbox" name="remember" id="remember"
                            {{ old('remember') ? 'checked' : '' }}>
                        <label class="form-check-label" for="remember">
                            @lang('Remember Me')
                        </label>
                    </div>

                    <div class="form-group">
                        <button type="submit" id="recaptcha" class="btn btn--base w-100">
                            @lang('Login')
                        </button>
                    </div>
                    <p class="mb-0">@lang('Don\'t have any account?') <a class="text--base"
                            href="{{ route('user.register') }}">@lang('Register')</a></p>
                </form>

            </div>
        </div>
        <div class="right bg_img"
            style="background-image: url('{{ frontendImage('login', @$content->background_image, '1920x1280') }}');">
            <div class="content text-center">
                <h2 class="title text-white">{{ __(@$content->heading) }}</h2>
                <p class="text-white mt-3">{{ __(@$content->sub_heading) }}</p>
            </div>
        </div>
    </section>
@endsection
