@extends($activeTemplate . 'layouts.auth')
@php
    $content = getContent('login.content', true)->data_values;
@endphp

@section('content')
    <section class="account-section">
        <div class="left">
            <div class="top-el">
                <img src="{{ frontendImage('login', @$content->texture_image_up, '1595x645') }}" alt="image">
            </div>
            <div class="bottom-el">
                <img src="{{ frontendImage('login', @$content->texture_image_down, '1595x645') }}" alt="image">
            </div>
            <div class="account-form-area">
                <div class="text-center">
                    <a class="site-logo site-title" href="{{ route('home') }}"><img src="{{ siteLogo() }}"
                            alt="Logo"></a>
                </div>


                <div class="d-flex justify-content-center mt-4">
                    <div class="verification-code-wrapper">
                        <div class="verification-area">
                            <form action="{{ route('user.password.verify.code') }}" method="POST"
                                class="account-form submit-form">
                                @csrf
                                <p class="verification-text">@lang('A 6 digit verification code sent to your email address') : {{ showEmailAddress($email) }}</p>
                                <input type="hidden" name="email" value="{{ $email }}">
                                @include($activeTemplate . 'partials.verification_code')
                                <div class="form-group">
                                    <button type="submit" class="btn btn--base w-100">@lang('Submit')</button>
                                </div>
                                <div class="form-group verification-text">
                                    @lang('Please check including your Junk/Spam Folder. if not found, you can')
                                    <a class="text--base" href="{{ route('user.password.request') }}">@lang('Try to send again')</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="right bg_img"
            style="background-image: url('{{ frontendImage('login', @$content->background_image, '1920x1280') }}');">
            <div class="content text-center">
                <h2 class="title text-white">@lang('Verify Code')</h2>

            </div>
        </div>
    </section>
@endsection

@push('style')
    <style>
        .verification-code input {
            letter-spacing: 39px;
        }
    </style>
@endpush
