@extends($activeTemplate . 'layouts.auth')
@php
    $content = getContent('login.content', true)->data_values;
@endphp
@section('content')
    <section class="account-section">
        <div class="left">
            <div class="top-el">
                <img src="{{ frontendImage('login', @$content->texture_image_up, '1595x645') }}" alt="image">
            </div>
            <div class="bottom-el">
                <img src="{{ frontendImage('login', @$content->texture_image_down, '1595x645') }}" alt="image">
            </div>
            <div class="account-form-area">
                <div class="text-center">
                    <a class="site-logo site-title" href="{{ route('home') }}"><img src="{{ siteLogo() }}" alt="Logo"></a>
                </div>

                <form method="POST" action="{{ route('user.password.email') }}" class="account-form mt-5 verify-gcaptcha">
                    @csrf
                    <div class="form-group">
                        <label class="form-label">@lang('Email or Username')</label>
                        <input type="text" class="form-control form--control" name="value" value="{{ old('value') }}" required autofocus="off">
                    </div>

                    <x-captcha />

                    <div class="form-group">
                        <button type="submit" class="btn btn--base w-100">@lang('Submit')</button>
                    </div>
                </form>


            </div>
        </div>
        <div class="right bg_img" style="background-image: url('{{ frontendImage('login', @$content->background_image, '1920x1280') }}');">
            <div class="content text-center">
                <h2 class="title text-white">@lang('Reset Password')</h2>

            </div>
        </div>
    </section>
@endsection
