@extends($activeTemplate . 'layouts.auth')
@php
    $content = getContent('login.content', true)->data_values;
@endphp
@section('content')
    <section class="account-section">
        <div class="left">
            <div class="top-el">
                <img src="{{ frontendImage('login', @$content->texture_image_up, '1595x645') }}" alt="image">
            </div>
            <div class="bottom-el">
                <img src="{{ frontendImage('login', @$content->texture_image_down, '1595x645') }}" alt="image">
            </div>
            <div class="account-form-area">
                <div class="text-center">
                    <a class="site-logo site-title" href="{{ route('home') }}"><img src="{{ siteLogo() }}" alt="Logo"></a>
                </div>

                <form class="account-form mt-5" method="POST" action="{{ route('user.password.update') }}">
                    @csrf
                    <input type="hidden" name="email" value="{{ $email }}">
                    <input type="hidden" name="token" value="{{ $token }}">
                    <div class="form-group">
                        <label class="form-label">@lang('Password')</label>
                        <input type="password" class="form-control form--control @if (gs('secure_password')) secure-password @endif" name="password" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">@lang('Confirm Password')</label>
                        <input type="password" class="form-control form--control" name="password_confirmation" required>
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn--base w-100"> @lang('Submit')</button>
                    </div>
                </form>


            </div>
        </div>
        <div class="right bg_img" style="background-image: url('{{ frontendImage('login', @$content->background_image, '1920x1280') }}');">
            <div class="content text-center">
                <h2 class="title text-white">@lang('Set New Password')</h2>

            </div>
        </div>
    </section>
@endsection

@if (gs('secure_password'))
    @push('script-lib')
        <script src="{{ asset('assets/global/js/secure_password.js') }}"></script>
    @endpush
@endif
