@extends($activeTemplate . 'layouts.master')
@section('content')
    <section class="pt-100 pb-100">
        <div class="container">

            <div class="notice"></div>

            @php
                $kyc = getContent('kyc.content', true);
            @endphp
            @if (auth()->user()->kv == Status::KYC_UNVERIFIED &&
                    auth()->user()->kyc_rejection_reason &&
                    auth()->user()->is_instructor)
                <div class="alert custom--card" role="alert">
                    <div class="d-flex justify-content-between">
                        <h4 class="alert-heading">@lang('KYC Documents Rejected')</h4>
                        <button class="btn btn-outline-secondary btn-sm" data-bs-toggle="modal"
                            data-bs-target="#kycRejectionReason">@lang('Show Reason')</button>
                    </div>
                    <hr>
                    <p class="mb-0">{{ __(@$kyc->data_values->reject) }} <a class="text--base"
                            href="{{ route('user.kyc.form') }}">@lang('Click Here to Re-submit Documents')</a>.</p>
                    <br>
                    <a class="text--base" href="{{ route('user.kyc.data') }}">@lang('See KYC Data')</a>
                </div>
            @elseif(auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->is_instructor)
                <div class="alert custom--card" role="alert">
                    <h4 class="alert-heading">@lang('KYC Verification required')</h4>
                    <hr>
                    <p class="mb-0">{{ __(@$kyc->data_values->required) }} <a class="text--base"
                            href="{{ route('user.kyc.form') }}">@lang('Click Here to Submit Documents')</a></p>
                </div>
            @elseif(auth()->user()->kv == Status::KYC_PENDING && auth()->user()->is_instructor)
                <div class="alert custom--card" role="alert">
                    <h4 class="alert-heading">@lang('KYC Verification pending')</h4>
                    <hr>
                    <p class="mb-0">{{ __(@$kyc->data_values->pending) }} <a class="text--base"
                            href="{{ route('user.kyc.data') }}">@lang('See KYC Data')</a></p>
                </div>
            @endif

            @if (auth()->user()->kv == Status::KYC_UNVERIFIED &&
                    auth()->user()->kyc_rejection_reason &&
                    auth()->user()->is_instructor)
                <div class="modal fade" id="kycRejectionReason">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">@lang('KYC Document Rejection Reason')</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <p>{{ auth()->user()->kyc_rejection_reason }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            @endif


            <div class="row gy-4 justify-content-center">
                <div class="col-xl-4 col-md-6 widget-item">
                    <div class="widget d-flex flex-wrap align-items-center rounded-3">
                        <div
                            class="widget__icon text-white d-inline-flex justify-content-center align-items-center rounded-2">
                            <i class="las la-school"></i>
                        </div>
                        <div class="widget__content">
                            <h3 class="widget__number">{{ $user->userCourses->count() }}</h3>
                            <p class="caption mt-1">@lang('Purchased Courses')</p>
                        </div>
                        <div class="widget__btn">
                            <a href="{{ route('user.course.purchased') }}" class="view-all">@lang('View All')</a>
                        </div>
                    </div><!-- widget end -->
                </div>
                <div class="col-xl-4 col-md-6 widget-item">
                    <div class="widget d-flex flex-wrap align-items-center rounded-3">
                        <div
                            class="widget__icon text-white d-inline-flex justify-content-center align-items-center rounded-2">
                            <i class="lar la-bookmark"></i>
                        </div>
                        <div class="widget__content">
                            <h3 class="widget__number">{{ $user->transactions->count() }}</h3>
                            <p class="caption mt-1">@lang('Total Transactions')</p>
                        </div>
                        <div class="widget__btn">
                            <a href="{{ route('user.transactions') }}" class="view-all">@lang('View All')</a>
                        </div>
                    </div><!-- widget end -->
                </div>
                <div class="col-xl-4 col-md-6 widget-item">
                    <div class="widget d-flex flex-wrap align-items-center rounded-3">
                        <div
                            class="widget__icon text-white d-inline-flex justify-content-center align-items-center rounded-2">
                            <i class="las la-wallet"></i>
                        </div>
                        <div class="widget__content">
                            <h3 class="widget__number">{{ gs()->cur_sym }}{{ getAmount($user->deposits->sum('amount')) }}
                            </h3>
                            <p class="caption mt-1">@lang('Total Deposit')</p>
                        </div>
                        <div class="widget__btn">
                            <a href="{{ route('user.deposit.history') }}" class="view-all">@lang('View All')</a>
                        </div>
                    </div><!-- widget end -->
                </div>
                @if ($user->is_instructor == 1)
                    <div class="col-xl-4 col-md-6 widget-item">
                        <div class="widget d-flex flex-wrap align-items-center rounded-3">
                            <div
                                class="widget__icon text-white d-inline-flex justify-content-center align-items-center rounded-2">
                                <i class="las la-clipboard-check"></i>
                            </div>
                            <div class="widget__content">
                                <h3 class="widget__number">
                                    {{ gs()->cur_sym }}{{ getAmount($user->Withdrawals->sum('amount')) }}</h3>
                                <p class="caption mt-1">@lang('Total Withdraw')</p>
                            </div>
                            <div class="widget__btn">
                                <a href="{{ route('user.withdraw.history') }}" class="view-all">@lang('View All')</a>
                            </div>
                        </div><!-- widget end -->
                    </div>
                    <div class="col-xl-4 col-md-6 widget-item">
                        <div class="widget d-flex flex-wrap align-items-center rounded-3">
                            <div
                                class="widget__icon text-white d-inline-flex justify-content-center align-items-center rounded-2">
                                <i class="las la-users"></i>
                            </div>
                            <div class="widget__content">
                                <h3 class="widget__number">{{ $user->totalEnrolled()->count() }}</h3>
                                <p class="caption mt-1">@lang('Total Student')</p>
                            </div>

                        </div><!-- widget end -->
                    </div>
                    <div class="col-xl-4 col-md-6 widget-item">
                        <div class="widget d-flex flex-wrap align-items-center rounded-3">
                            <div
                                class="widget__icon text-white d-inline-flex justify-content-center align-items-center rounded-2">
                                <i class="las la-film"></i>
                            </div>
                            <div class="widget__content">
                                <h3 class="widget__number">{{ $user->courses()->count() }}</h3>
                                <p class="caption mt-1">@lang('Total Approved Course')</p>
                            </div>
                            <div class="widget__btn">
                                <a href="{{ route('user.courses') }}" class="view-all">@lang('View All')</a>
                            </div>
                        </div><!-- widget end -->
                    </div>
                @endif
            </div><!-- row end -->

            <h4 class="mt-5 mb-3">@lang('Latest Transactions')</h4>

            <div class="custom--card">
                <div class="card-body p-0">
                    <div class="table-responsive table-responsive--md">
                        <table class="table custom--table mb-0">
                            <thead>
                                <tr>
                                    <th>@lang('Trx')</th>
                                    <th>@lang('Transacted')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('Post Balance')</th>
                                    <th>@lang('Detail')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($trxs as $trx)
                                    <tr>
                                        <td>
                                            <strong class="text--base">{{ $trx->trx }}</strong>
                                        </td>

                                        <td>
                                            {{ showDateTime($trx->created_at) }}<br>{{ diffForHumans($trx->created_at) }}
                                        </td>

                                        <td>
                                            <span
                                                class="fw-bold @if ($trx->trx_type == '+') text--success @else text--danger @endif">
                                                {{ $trx->trx_type }} {{ showAmount($trx->amount) }}
                                            </span>
                                        </td>

                                        <td>
                                            {{ showAmount($trx->post_balance) }}
                                        </td>


                                        <td>{{ __($trx->details) }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </section>
@endsection
