<?php

use Illuminate\Support\Facades\Route;

Route::namespace('User\Auth')->name('user.')->middleware('guest')->group(function ()
{
    Route::controller('LoginController')->group(function ()
    {
        Route::get('/login', 'showLoginForm')->name('login');
        Route::post('/login', 'login');
        Route::get('logout', 'logout')->middleware('auth')->withoutMiddleware('guest')->name('logout');
    });

    Route::controller('RegisterController')->middleware(['guest'])->group(function ()
    {
        Route::get('register', 'showRegistrationForm')->name('register');
        Route::post('register', 'register');
        Route::post('check-user', 'checkUser')->name('checkUser')->withoutMiddleware('guest');
    });

    Route::controller('ForgotPasswordController')->prefix('password')->name('password.')->group(function ()
    {
        Route::get('reset', 'showLinkRequestForm')->name('request');
        Route::post('email', 'sendResetCodeEmail')->name('email');
        Route::get('code-verify', 'codeVerify')->name('code.verify');
        Route::post('verify-code', 'verifyCode')->name('verify.code');
    });

    Route::controller('ResetPasswordController')->group(function ()
    {
        Route::post('password/reset', 'reset')->name('password.update');
        Route::get('password/reset/{token}', 'showResetForm')->name('password.reset');
    });

    Route::controller('SocialiteController')->group(function ()
    {
        Route::get('social-login/{provider}', 'socialLogin')->name('social.login');
        Route::get('social-login/callback/{provider}', 'callback')->name('social.login.callback');
    });
});

Route::middleware('auth')->name('user.')->group(function ()
{

    Route::get('user-data', 'User\UserController@userData')->name('data');
    Route::post('user-data-submit', 'User\UserController@userDataSubmit')->name('data.submit');

    //authorization
    Route::middleware('registration.complete')->namespace('User')->controller('AuthorizationController')->group(function ()
    {
        Route::get('authorization', 'authorizeForm')->name('authorization');
        Route::get('resend-verify/{type}', 'sendVerifyCode')->name('send.verify.code');
        Route::post('verify-email', 'emailVerification')->name('verify.email');
        Route::post('verify-mobile', 'mobileVerification')->name('verify.mobile');
        Route::post('verify-g2fa', 'g2faVerification')->name('2fa.verify');
    });

    Route::middleware(['check.status', 'registration.complete'])->group(function ()
    {

        Route::namespace('User')->group(function ()
        {

            Route::controller('UserController')->group(function ()
            {
                Route::get('dashboard', 'home')->name('home');
                Route::get('download-attachments/{file_hash}', 'downloadAttachment')->name('download.attachment');

                //2FA
                Route::get('twofactor', 'show2faForm')->name('twofactor');
                Route::post('twofactor/enable', 'create2fa')->name('twofactor.enable');
                Route::post('twofactor/disable', 'disable2fa')->name('twofactor.disable');

                //KYC
                Route::get('kyc-form', 'kycForm')->name('kyc.form')->middleware('instructor');
                Route::get('kyc-data', 'kycData')->name('kyc.data')->middleware('instructor');
                Route::post('kyc-submit', 'kycSubmit')->name('kyc.submit')->middleware('instructor');

                //Report
                Route::any('deposit/history', 'depositHistory')->name('deposit.history');
                Route::get('transactions', 'transactions')->name('transactions');

                Route::post('add-device-token', 'addDeviceToken')->name('add.device.token');

                Route::get('become/instructor', 'becomeInstructor')->name('become.instructor');
                Route::post('/instructor/submit', 'applyAsInstructor')->name('apply.instructor');
                Route::post('post/comment', 'postComment')->name('post.comment');

                Route::post('apply-coupon', 'applyCoupon')->name('apply.coupon');
            });

            Route::middleware('instructor')->group(function ()
            {
                Route::controller('CourseController')->group(function ()
                {
                    Route::get('courses', 'courses')->name('courses');
                    Route::get('create/course', 'create')->name('create.course');
                    Route::post('create/course', 'store');
                    Route::get('edit/course/{id}-{slug}', 'edit')->name('edit.course');
                    Route::post('update/course', 'update')->name('update.course');
                    Route::get('publish/course/{code}', 'publish')->name('course.publish');
                });

                //chapter
                Route::controller('ChapterController')->prefix('course')->name('course.')->group(function ()
                {
                    Route::get('chapter/{id}-{slug}', 'chapters')->name('chapters');
                    Route::post('chapter/store', 'store')->name('chapter.store');
                    Route::post('chapter/update', 'update')->name('chapter.update');
                });

                //chapter
                Route::controller('LectureController')->prefix('course')->name('course.')->group(function ()
                {
                    Route::get('lectures/{course}/{chapter}', 'lectures')->name('lectures');
                    Route::get('create/lectures/{course}/{chapter}', 'create')->name('lecture.create');
                    Route::post('lecture/store', 'store')->name('lecture.store');
                    Route::get('edit/lectures/{course}/{chapter}/{lecture}', 'edit')->name('lecture.edit');
                    Route::post('lecture/update', 'update')->name('lecture.update');
                });
            });

            Route::get('/course/lecture/file/download/{id}', 'LectureController@fileDownload')->name('course.lecture.file.download');

            Route::controller('CourseController')->group(function ()
            {
                Route::get('purchased/courses/', 'purchasedCourses')->name('course.purchased');
                Route::get('/course/play/{id}-{slug}', 'coursePlay')->name('course.play');
                Route::post('/review', 'review')->name('review');
                Route::post('/purchase/course', 'purchaseCourse')->name('purchase');
            });

            //Profile setting
            Route::controller('ProfileController')->group(function ()
            {
                Route::get('profile-setting', 'profile')->name('profile.setting');
                Route::post('profile-setting', 'submitProfile');
                Route::get('change-password', 'changePassword')->name('change.password');
                Route::post('change-password', 'submitPassword');
            });


            // Withdraw
            Route::controller('WithdrawController')->prefix('withdraw')->name('withdraw')->middleware('instructor')->group(function ()
            {
                Route::middleware('kyc')->group(function ()
                {
                    Route::get('/', 'withdrawMoney');
                    Route::post('/', 'withdrawStore')->name('.money');
                    Route::get('preview', 'withdrawPreview')->name('.preview');
                    Route::post('preview', 'withdrawSubmit')->name('.submit');
                });
                Route::get('history', 'withdrawLog')->name('.history');
            });
        });

        Route::get('/payment/{code}', 'Gateway\PaymentController@payment')->name('payment');

        // Payment
        Route::prefix('deposit')->name('deposit.')->controller('Gateway\PaymentController')->group(function ()
        {
            Route::any('/', 'deposit')->name('index');
            Route::post('insert', 'depositInsert')->name('insert');
            Route::get('confirm', 'depositConfirm')->name('confirm');
            Route::get('manual', 'manualDepositConfirm')->name('manual.confirm');
            Route::post('manual', 'manualDepositUpdate')->name('manual.update');
        });
    });
});
